% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions_v8.R
\name{AddDimension}
\alias{AddDimension}
\title{Add Dimension to a Molten Data Frame}
\usage{
AddDimension(x, y)
}
\arguments{
\item{x}{a matrix or data.frame with at least 1 row and 1 column.}

\item{y}{a vector with elements that will be added to x}
}
\value{
a matrix with an extra column as compared to x
}
\description{
Creates a new (molten) data matrix where all elements of y
are added to each row of x. Each row in x is recycled
for each element in y. Elements in y are added as
the first column in the returned matrix.
}
\examples{
cellmigRation:::AddDimension(
    x = cbind(seq(1,4,by=1), seq(4,1,by=-1)),
    y = c(9, 7))

}
\references{
\url{https://www.data-pulse.com/dev_site/cellmigration/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
\keyword{internal}
