% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reorderCelda.R
\name{reorderCelda}
\alias{reorderCelda}
\alias{reorderCelda,SingleCellExperiment,ANY-method}
\alias{reorderCelda,matrix,celda_CG-method}
\alias{reorderCelda,matrix,celda_C-method}
\alias{reorderCelda,matrix,celda_G-method}
\title{Reorder cells populations and/or features modules using
 hierarchical clustering}
\usage{
reorderCelda(
  x,
  celdaMod,
  useAssay = "counts",
  altExpName = "featureSubset",
  method = "complete"
)

\S4method{reorderCelda}{SingleCellExperiment,ANY}(
  x,
  useAssay = "counts",
  altExpName = "featureSubset",
  method = "complete"
)

\S4method{reorderCelda}{matrix,celda_CG}(x, celdaMod, method = "complete")

\S4method{reorderCelda}{matrix,celda_C}(x, celdaMod, method = "complete")

\S4method{reorderCelda}{matrix,celda_G}(x, celdaMod, method = "complete")
}
\arguments{
\item{x}{Can be one of
\itemize{
\item A \linkS4class{SingleCellExperiment} object returned by
\link{celda_C}, \link{celda_G} or \link{celda_CG}, with the matrix
located in the \code{useAssay} assay slot in \code{altExp(x, altExpName)}.
Rows represent features and columns represent cells.
\item Integer count matrix. Rows represent features and columns represent
cells. This matrix should be the same as the one used to generate
\code{celdaMod}.}}

\item{celdaMod}{Celda model object. Only works if \code{x} is an integer
counts matrix. Ignored if \code{x} is a
\linkS4class{SingleCellExperiment} object.}

\item{useAssay}{A string specifying which \link{assay}
slot to use if \code{x} is a \linkS4class{SingleCellExperiment} object.
Default "counts".}

\item{altExpName}{The name for the \link{altExp} slot.
Default "featureSubset".}

\item{method}{Passed to \link{hclust}. The agglomeration method
to be used to be used. Default "complete".}
}
\value{
A \linkS4class{SingleCellExperiment} object (or Celda model object)
 with updated cell cluster and/or feature module labels.
}
\description{
Apply hierarchical clustering to reorder the cell populations
 and/or feature modules and group similar ones together based
 on the cosine distance of the factorized matrix
 from \link{factorizeMatrix}.
}
\examples{
data(sceCeldaCG)
reordersce <- reorderCelda(sceCeldaCG)
data(celdaCGSim, celdaCGMod)
reorderCeldaCG <- reorderCelda(celdaCGSim$counts, celdaCGMod)
data(celdaCSim, celdaCMod)
reorderCeldaC <- reorderCelda(celdaCSim$counts, celdaCMod)
data(celdaGSim, celdaGMod)
reorderCeldaG <- reorderCelda(celdaGSim$counts, celdaGMod)
}
