% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dr.R
\name{plotDimReduceFeature}
\alias{plotDimReduceFeature}
\alias{plotDimReduceFeature,SingleCellExperiment-method}
\alias{plotDimReduceFeature,ANY-method}
\title{Plotting feature expression on a dimension reduction plot}
\usage{
plotDimReduceFeature(
  x,
  features,
  reducedDimName = NULL,
  displayName = NULL,
  dim1 = NULL,
  dim2 = NULL,
  headers = NULL,
  useAssay = "counts",
  altExpName = "featureSubset",
  normalize = FALSE,
  zscore = TRUE,
  exactMatch = TRUE,
  trim = c(-2, 2),
  limits = c(-2, 2),
  size = 0.5,
  xlab = NULL,
  ylab = NULL,
  colorLow = "blue4",
  colorMid = "grey90",
  colorHigh = "firebrick1",
  midpoint = 0,
  ncol = NULL,
  decreasing = FALSE
)

\S4method{plotDimReduceFeature}{SingleCellExperiment}(
  x,
  features,
  reducedDimName = NULL,
  displayName = NULL,
  dim1 = 1,
  dim2 = 2,
  headers = NULL,
  useAssay = "counts",
  altExpName = "featureSubset",
  normalize = FALSE,
  zscore = TRUE,
  exactMatch = TRUE,
  trim = c(-2, 2),
  limits = c(-2, 2),
  size = 0.5,
  xlab = NULL,
  ylab = NULL,
  colorLow = "blue4",
  colorMid = "grey90",
  colorHigh = "firebrick1",
  midpoint = 0,
  ncol = NULL,
  decreasing = FALSE
)

\S4method{plotDimReduceFeature}{ANY}(
  x,
  features,
  dim1,
  dim2,
  headers = NULL,
  normalize = FALSE,
  zscore = TRUE,
  exactMatch = TRUE,
  trim = c(-2, 2),
  limits = c(-2, 2),
  size = 0.5,
  xlab = "Dimension_1",
  ylab = "Dimension_2",
  colorLow = "blue4",
  colorMid = "grey90",
  colorHigh = "firebrick1",
  midpoint = 0,
  ncol = NULL,
  decreasing = FALSE
)
}
\arguments{
\item{x}{Numeric matrix or a \linkS4class{SingleCellExperiment} object
with the matrix located in the assay slot under \code{useAssay}. Rows
represent features and columns represent cells.}

\item{features}{Character vector. Features in the rownames of counts to plot.}

\item{reducedDimName}{The name of the dimension reduction slot in
\code{reducedDimNames(x)} if \code{x} is a
\linkS4class{SingleCellExperiment} object. If \code{NULL}, then both
\code{dim1} and \code{dim2} need to be set. Default \code{NULL}.}

\item{displayName}{Character. The column name of
\code{rowData(x)} that specifies the display names for
the features. Default \code{NULL}, which displays the row names. Only works
if \code{x} is a \linkS4class{SingleCellExperiment} object. Overwrites
\code{headers}.}

\item{dim1}{Integer or numeric vector. If \code{reducedDimName} is supplied,
then, this will be used as an index to determine which dimension will be
plotted on the x-axis. If \code{reducedDimName} is not supplied, then this
should be a vector which will be plotted on the x-axis. Default \code{1}.}

\item{dim2}{Integer or numeric vector. If \code{reducedDimName} is supplied,
then, this will be used as an index to determine which dimension will be
plotted on the y-axis. If \code{reducedDimName} is not supplied, then this
should be a vector which will be plotted on the y-axis. Default \code{2}.}

\item{headers}{Character vector. If \code{NULL}, the corresponding
rownames are used as labels. Otherwise, these headers are used to label
the features. Only works if \code{displayName} is \code{NULL} and
\code{exactMatch} is \code{FALSE}.}

\item{useAssay}{A string specifying which \link{assay}
slot to use if \code{x} is a
\linkS4class{SingleCellExperiment} object. Default "counts".}

\item{altExpName}{The name for the \link{altExp} slot
to use. Default "featureSubset".}

\item{normalize}{Logical. Whether to normalize the columns of `counts`.
Default \code{FALSE}.}

\item{zscore}{Logical. Whether to scale each feature to have a mean 0
and standard deviation of 1. Default \code{TRUE}.}

\item{exactMatch}{Logical. Whether an exact match or a partial match using
\code{grep()} is used to look up the feature in the rownames of the counts
 matrix. Default TRUE.}

\item{trim}{Numeric vector. Vector of length two that specifies the lower
and upper bounds for the data. This threshold is applied after row scaling.
Set to NULL to disable. Default \code{c(-1,1)}.}

\item{limits}{Passed to \link{scale_colour_gradient2}. The range
of color scale.}

\item{size}{Numeric. Sets size of point on plot. Default 1.}

\item{xlab}{Character vector. Label for the x-axis. If \code{reducedDimName}
is used, then this will be set to the column name of the first dimension of
that object. Default "Dimension_1".}

\item{ylab}{Character vector. Label for the y-axis. If \code{reducedDimName}
is used, then this will be set to the column name of the second dimension of
that object. Default "Dimension_2".}

\item{colorLow}{Character. A color available from `colors()`. The color
will be used to signify the lowest values on the scale.}

\item{colorMid}{Character. A color available from `colors()`. The color
will be used to signify the midpoint on the scale.}

\item{colorHigh}{Character. A color available from `colors()`. The color
will be used to signify the highest values on the scale.}

\item{midpoint}{Numeric. The value indicating the midpoint of the
diverging color scheme. If \code{NULL}, defaults to the mean
with 10 percent of values trimmed. Default \code{0}.}

\item{ncol}{Integer. Passed to \link[ggplot2]{facet_wrap}. Specify the
number of columns for facet wrap.}

\item{decreasing}{logical. Specifies the order of plotting the points.
If \code{FALSE}, the points will be plotted in increasing order where
the points with largest values will be on top. \code{TRUE} otherwise.
If \code{NULL}, no sorting is performed. Points will be plotted in their
current order in \code{x}. Default \code{FALSE}.}
}
\value{
The plot as a ggplot object
}
\description{
Create a scatterplot for each row of a normalized gene
 expression matrix where x and y axis are from a data dimension
 reduction tool. The cells are colored by expression of
 the specified feature.
}
\examples{
data(sceCeldaCG)
sce <- celdaTsne(sceCeldaCG)
plotDimReduceFeature(x = sce,
  reducedDimName = "celda_tSNE",
  normalize = TRUE,
  features = c("Gene_98", "Gene_99"),
  exactMatch = TRUE)
library(SingleCellExperiment)
data(sceCeldaCG)
sce <- celdaTsne(sceCeldaCG)
plotDimReduceFeature(x = counts(sce),
  dim1 = reducedDim(altExp(sce), "celda_tSNE")[, 1],
  dim2 = reducedDim(altExp(sce), "celda_tSNE")[, 2],
  normalize = TRUE,
  features = c("Gene_98", "Gene_99"),
  exactMatch = TRUE)
}
