% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dr.R
\name{plotCeldaViolin}
\alias{plotCeldaViolin}
\alias{plotCeldaViolin,SingleCellExperiment-method}
\alias{plotCeldaViolin,ANY-method}
\title{Feature Expression Violin Plot}
\usage{
plotCeldaViolin(
  x,
  celdaMod,
  features,
  displayName = NULL,
  useAssay = "counts",
  altExpName = "featureSubset",
  exactMatch = TRUE,
  plotDots = TRUE,
  dotSize = 0.1
)

\S4method{plotCeldaViolin}{SingleCellExperiment}(
  x,
  features,
  displayName = NULL,
  useAssay = "counts",
  altExpName = "featureSubset",
  exactMatch = TRUE,
  plotDots = TRUE,
  dotSize = 0.1
)

\S4method{plotCeldaViolin}{ANY}(
  x,
  celdaMod,
  features,
  exactMatch = TRUE,
  plotDots = TRUE,
  dotSize = 0.1
)
}
\arguments{
\item{x}{Numeric matrix or a \linkS4class{SingleCellExperiment} object
with the matrix located in the assay slot under \code{useAssay}. Rows
represent features and columns represent cells.}

\item{celdaMod}{Celda object of class "celda_G" or "celda_CG". Used only if
\code{x} is a matrix object.}

\item{features}{Character vector. Uses these genes for plotting.}

\item{displayName}{Character. The column name of
\code{rowData(x)} that specifies the display names for
the features. Default \code{NULL}, which displays the row names. Only works
if \code{x} is a \linkS4class{SingleCellExperiment} object.}

\item{useAssay}{A string specifying which \link{assay}
slot to use if \code{x} is a
\linkS4class{SingleCellExperiment} object. Default "counts".}

\item{altExpName}{The name for the \link{altExp} slot
to use. Default "featureSubset".}

\item{exactMatch}{Logical. Whether an exact match or a partial match using
\code{grep()} is used to look up the feature in the rownames of the counts
 matrix. Default \code{TRUE}.}

\item{plotDots}{Boolean. If \code{TRUE}, the
expression of features will be plotted as points in addition to the violin
curve. Default \code{TRUE}.}

\item{dotSize}{Numeric. Size of points if \code{plotDots = TRUE}.
Default \code{0.1}.}
}
\value{
Violin plot for each feature, grouped by celda cluster
}
\description{
Outputs a violin plot for feature expression data.
}
\examples{
data(sceCeldaCG)
plotCeldaViolin(x = sceCeldaCG, features = "Gene_1")
data(celdaCGSim, celdaCGMod)
plotCeldaViolin(x = celdaCGSim$counts,
   celdaMod = celdaCGMod,
   features = "Gene_1")
}
