% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneSetEnrich.R
\name{geneSetEnrich}
\alias{geneSetEnrich}
\alias{geneSetEnrich,SingleCellExperiment-method}
\alias{geneSetEnrich,matrix-method}
\title{Gene set enrichment}
\usage{
geneSetEnrich(
  x,
  celdaModel,
  useAssay = "counts",
  altExpName = "featureSubset",
  databases,
  fdr = 0.05
)

\S4method{geneSetEnrich}{SingleCellExperiment}(
  x,
  useAssay = "counts",
  altExpName = "featureSubset",
  databases,
  fdr = 0.05
)

\S4method{geneSetEnrich}{matrix}(x, celdaModel, databases, fdr = 0.05)
}
\arguments{
\item{x}{A numeric \link{matrix} of counts or a
\linkS4class{SingleCellExperiment}
with the matrix located in the assay slot under \code{useAssay}.
Rows represent features and columns represent cells. Rownames of the
matrix or \linkS4class{SingleCellExperiment} object should be gene names.}

\item{celdaModel}{Celda object of class \code{celda_G} or \code{celda_CG}.}

\item{useAssay}{A string specifying which \link{assay}
slot to use if \code{x} is a
\linkS4class{SingleCellExperiment} object. Default "counts".}

\item{altExpName}{The name for the \link{altExp} slot
to use. Default "featureSubset".}

\item{databases}{Character vector. Name of reference database. Available
databases can be viewed by \link[enrichR]{listEnrichrDbs}.}

\item{fdr}{False discovery rate (FDR). Numeric. Cutoff value for adjusted
p-value, terms with FDR below this value are considered significantly
enriched.}
}
\value{
List of length 'L' where each member contains the significantly
 enriched terms for the corresponding module.
}
\description{
Identify and return significantly-enriched terms for each gene
 module in a Celda object or a \linkS4class{SingleCellExperiment} object.
 Performs gene set enrichment analysis for Celda
 identified modules using the \link[enrichR]{enrichr}.
}
\examples{
library(M3DExampleData)
counts <- M3DExampleData::Mmus_example_list$data
# subset 500 genes for fast clustering
counts <- counts[seq(1501, 2000), ]
# cluster genes into 10 modules for quick demo
sce <- celda_G(x = as.matrix(counts), L = 10, verbose = FALSE)
gse <- geneSetEnrich(sce,
  databases = c("GO_Biological_Process_2018", "GO_Molecular_Function_2018"))
}
\author{
Ahmed Youssef, Zhe Wang
}
