% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrasting_functions.r
\name{subset_cells_by_group}
\alias{subset_cells_by_group}
\title{subset_cells_by_group}
\usage{
subset_cells_by_group(dataset_se, n.group = 1000)
}
\arguments{
\item{dataset_se}{Summarised experiment object containing count data. Also
requires 'ID' and 'group' to be set within the cell information.}

\item{n.group}{How many cells to keep for each group. Default = 1000}
}
\value{
\emph{dataset_se} A hopefully more managably subsetted version of
the inputted \bold{dataset_se}.
}
\description{
Utility function to randomly subset very large datasets (that use too much
memory). Specify a maximum number of cells to keep per group and use the 
subsetted version to analysis.
}
\details{
The resulting 
differential expression table \emph{de_table} will have reduced statistical 
power.
But as long as enough cells are left to reasonably accurately
calculate differnetial expression between groups this should be enough for
celaref to work with.

Also, this function will lose proportionality of groups
 (there'll be \emph{n.groups} or less of each). 
Consider using the n.group/n.other parameters in 
\emph{contrast_each_group_to_the_rest} or 
\emph{contrast_the_group_to_the_rest}  - 
which subsets non-group cells independantly for each group. 
That may be more approriate for tissue type samples which would have similar 
compositions of cells. 
 
So this function is intended for use when either; the 
proportionality isn't relevant (e.g. FACs purified cell populations),
or, the data is just too big to work with otherwise.

Cells are randomly sampled, so set the random seed (with \emph{set.seed()})
for consistant results across runs.
}
\examples{

dataset_se.30pergroup <- subset_cells_by_group(demo_query_se, n.group=30)

}
\seealso{
\code{\link{contrast_each_group_to_the_rest}} For alternative method 
of subsetting cells proportionally.
}
