% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_node_perturbation.R
\name{find_node_perturbation}
\alias{find_node_perturbation}
\title{Calculates average expression changes of all (or specified)
nodes except trigger and finds the perturbed node count for
all (or specified) nodes in system.}
\usage{
find_node_perturbation(input_graph, how = 2, cycle = 1, limit = 0, fast = 0)
}
\arguments{
\item{input_graph}{The graph object that was processed with priming_graph function.}

\item{how}{The change of count (expression) of the given node in terms of fold change.}

\item{cycle}{The iteration of simulation.}

\item{limit}{The minimum fold change which can be taken into account for
perturbation calculation on all nodes in terms of percentage.}

\item{fast}{specifies percentage of affected target in target expression.
For example, if fast = 1, the nodes that are affected from miRNA repression
activity more than one percent of their expression is determined as subgraph.}
}
\value{
It gives a tibble form dataset that includes node names,
perturbation efficiency and perturbed count of nodes.
}
\description{
Calculates average expression changes of all (or specified)
nodes except trigger and finds the perturbed node count for
all (or specified) nodes in system.
}
\details{
find_node_perturbation calculates mean expression changes
of elements after the change in the network in terms of percentage.
It also calculates the number of nodes that have expression changes
after the change occur in the network. The outputs of the function
are the perturbation efficiency and perturbed count of nodes for
each nodes.
}
\examples{

data('minsamp')
data('midsamp')

 minsamp\%>\%
  priming_graph(competing_count = Competing_expression, miRNA_count = miRNA_expression)\%>\%
  find_node_perturbation()\%>\%
  select(name, perturbation_efficiency, perturbed_count)


 minsamp\%>\%
  priming_graph(competing_count = Competing_expression, miRNA_count = miRNA_expression,
    aff_factor = c(energy,seed_type), deg_factor = region)\%>\%
  find_node_perturbation(how = 3, cycle = 4)\%>\%
  select(name, perturbation_efficiency, perturbed_count)

 midsamp\%>\%
  priming_graph(competing_count = Gene_expression, miRNA_count = miRNA_expression)\%>\%
  find_node_perturbation(how = 2, cycle= 3, limit=1, fast = 5)\%>\%
  select(name, perturbation_efficiency, perturbed_count)


}
