% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmapR_subset.R
\name{processIds}
\alias{processIds}
\title{Return a subset of requested GCTX row/column ids
out of the universe of all ids}
\source{
\url{https://github.com/cmap/cmapR}
}
\usage{
processIds(ids, all_ids, type = "rid")
}
\arguments{
\item{ids}{vector of requested ids. If \code{NULL}, no
subsetting is performed}

\item{all_ids}{vector of universe of ids}

\item{type}{flag indicating the type of ids being processed}
}
\value{
a list with the following elements
 \code{ids}: a character vector of the processed ids
 \code{idx}: an integer list of their corresponding indices in \code{all_ids}
}
\description{
Return a subset of requested GCTX row/column ids
out of the universe of all ids
}
\details{
This is a low-level helper function
  which most users will not need to access directly
}
\seealso{
Other GCTX parsing functions: 
\code{\link{fix.datatypes}()},
\code{\link{readGctxIds}()},
\code{\link{readGctxMeta}()}
}
\concept{GCTX parsing functions}
\keyword{internal}
