% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drugSetEnrichment.R
\name{plotDrugSetEnrichment}
\alias{plotDrugSetEnrichment}
\title{Plot drug set enrichment}
\usage{
plotDrugSetEnrichment(
  sets,
  stats,
  col = "rankProduct_rank",
  selectedSets = NULL,
  keyColSets = NULL,
  keyColStats = NULL
)
}
\arguments{
\item{sets}{Named list of characters: named sets containing compound
identifiers (obtain drug sets by running \code{prepareDrugSets()})}

\item{stats}{Named numeric vector or either a \code{similarPerturbations} or
a \code{targetingDrugs} object (obtained after running
\code{\link{rankSimilarPerturbations}} or
\code{\link{predictTargetingDrugs}}, respectively)}

\item{col}{Character: name of the column to use for statistics (only required
if class of \code{stats} is either \code{similarPerturbations} or
\code{targetingDrugs})}

\item{selectedSets}{Character: drug sets to plot (if \code{NULL}, plot all)}

\item{keyColSets}{Character: column from \code{sets} to compare with column
\code{keyColStats} from \code{stats}; automatically selected if \code{NULL}}

\item{keyColStats}{Character: column from \code{stats} to compare with column
\code{keyColSets} from \code{sets}; automatically selected if \code{NULL}}
}
\value{
List of GSEA plots per drug set
}
\description{
Plot drug set enrichment
}
\examples{
descriptors <- loadDrugDescriptors()
drugSets <- prepareDrugSets(descriptors)

# Analyse drug set enrichment in ranked targeting drugs for a differential
# expression profile
data("diffExprStat")
gdsc      <- loadExpressionDrugSensitivityAssociation("GDSC")
predicted <- predictTargetingDrugs(diffExprStat, gdsc)

plotDrugSetEnrichment(drugSets, predicted)
}
\seealso{
Other functions for drug set enrichment analysis: 
\code{\link{analyseDrugSetEnrichment}()},
\code{\link{loadDrugDescriptors}()},
\code{\link{prepareDrugSets}()}
}
\concept{functions for drug set enrichment analysis}
