% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drugSetEnrichment.R
\name{calculateEvenlyDistributedBins}
\alias{calculateEvenlyDistributedBins}
\title{Calculate evenly-distributed bins}
\usage{
calculateEvenlyDistributedBins(
  numbers,
  maxBins = 15,
  k = 5,
  minPoints = NULL,
  ...,
  ids = NULL
)
}
\arguments{
\item{numbers}{Numeric}

\item{maxBins}{Numeric: maximum number of bins for numeric columns}

\item{k}{Numeric: constant; the higher the constant, the smaller the bin size
(check \code{minpts})}

\item{minPoints}{Numeric: minimum number of points in a bin (if \code{NULL},
the minimum number of points is the number of non-missing values divided by
\code{maxBins} divided by \code{k})}

\item{...}{
  Arguments passed on to \code{\link[binr:bins]{binr::bins}}
  \describe{
    \item{\code{max.breaks}}{Used for initial cut. If \code{exact.groups} is \code{FALSE}, bins are merged
until there's no bins with fewer than \code{length(x) / max.breaks} points.
In \code{bins}, one of \code{max.breaks} and \code{minpts} must be supplied.}
    \item{\code{exact.groups}}{if TRUE, the result will have exactly the number of target.bins;
if FALSE, the result may contain fewer than target.bins bins}
    \item{\code{verbose}}{Indicates verbose output.}
    \item{\code{errthresh}}{If the error is below the provided value, stops after the first rough estimate of the bins.}
  }}
}
\value{
Factor containing the respective group of each element in
  \code{numbers}
}
\description{
Calculate evenly-distributed bins
}
\keyword{internal}
