% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotHeatmap}
\alias{plotHeatmap}
\title{Genome wide heatmap of template inheritance states}
\usage{
plotHeatmap(files2plot, file = NULL, hotspots = NULL)
}
\arguments{
\item{files2plot}{A list of files that contains \code{\link{BreakPoint}} objects or a single \code{\link{BreakPoint}} object.}

\item{file}{Name of the file to plot to.}

\item{hotspots}{A \code{\link{GRanges-class}} object with locations of breakpoint hotspots.}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot}} object.
}
\description{
Plot a genome-wide heatmap of template inheritance states from a \code{\link{BreakPoint}} object.
}
\examples{
## Get example BreakPoint objects to plot
exampleFolder <- system.file("extdata", "example_results", package="breakpointRdata")
exampleFiles <- list.files(exampleFolder, full.names=TRUE)
breakpoint.objects <- loadFromFiles(exampleFiles)
## Plot the heatmap
plotHeatmap(breakpoint.objects)

}
\author{
David Porubsky, Aaron Taudt, Ashley Sanders
}
