% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportRegions.R
\name{exportRegions}
\alias{exportRegions}
\title{Function to print WC regions after breakpointR analysis}
\usage{
exportRegions(
  datapath,
  file = NULL,
  collapseInversions = FALSE,
  collapseRegionSize = 5e+06,
  minRegionSize = 5e+06,
  state = "wc"
)
}
\arguments{
\item{datapath}{A path to that}

\item{file}{A filename to print exported regions to.}

\item{collapseInversions}{Set to \code{TRUE} if you want to collapse putative inverted regions.}

\item{collapseRegionSize}{Upper range of what sized regions should be collapsed.}

\item{minRegionSize}{Minimal size of the region to be reported.}

\item{state}{A genotype of the regions to be exported ('ww', 'cc' or 'wc').}
}
\value{
A \code{data.frame} object containing all regions with user defined 'state'.
}
\description{
Function to print WC regions after breakpointR analysis
}
\examples{
## Get an example file
exampleFolder <- system.file("extdata", "example_results", package="breakpointRdata")
## To export regions genotyped as 'wc'
wc.regions <- exportRegions(datapath=exampleFolder, collapseInversions=FALSE, minRegionSize=5000000, state='wc') 
}
\author{
David Porubsky
}
