% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fexpit.R
\name{fexpit}
\alias{fexpit}
\title{Helper function: expanded expit}
\usage{
fexpit(x, sqz = 1e-06)
}
\arguments{
\item{x}{a vector of values between -Inf and +Inf}

\item{sqz}{the amount by which we 'squoze', default is .000001}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{   a vector of values between 0 and 1 inclusive
}\if{html}{\out{</div>}}
}
\description{
Helper function: expanded expit
}
\examples{

  set.seed(1234)
  x <- rnorm(n=1000)
  summary(x) 

  sqz <- 1 / (10**6)
  p <- fexpit(x, sqz=sqz)
  summary(p)

  all( (abs(x - flogit(p)) / x) < sqz )
  all( abs(x - flogit(fexpit(x))) < sqz )

}
