#' ENSR_subset data from hg19 genome
#'
#' Subset of ENSEMBL regulatory build regions for hg19 genome
#'
#' Source URL: homo_sapiens.GRCh37.Regulatory_Build.regulatory_features.20161117.gff.gz
#' (regions that overlap Inifinium annotation manifests - described at
#' http://zwdzwd.github.io/InfiniumAnnotation - are selected for final GRanges)
#' Source type: GFF
#' Return type: GRanges
#'
#' @name ENSR_subset.hg19
#' @docType data
#' @keywords data
#' @usage data(ENSR_subset.hg19, package="biscuiteer")
#'
NULL

#' ENSR_subset data from hg38 genome
#'
#' Subset of ENSEMBL regulatory build regions for hg19 genome
#'
#' Source URL: homo_sapiens.GRCh38.Regulatory_Build.regulatory_features.20161111.gff.gz
#' (regions that overlap Inifinium annotation manifests - described at
#' http://zwdzwd.github.io/InfiniumAnnotation - are selected for final GRanges)
#' Source type: GFF
#' Return type: GRanges
#'
#' @name ENSR_subset.hg38
#' @docType data
#' @keywords data
#' @usage data(ENSR_subset.hg38, package="biscuiteer")
#'
NULL

#' hg19.chromArm
#'
#' Chromosome arm locations for hg19 genome
#'
#' Source URL: http://hgdownload.cse.ucsc.edu/goldenPath/hg19/database/cytoBand.txt.gz
#' (Chromosome arms were combined to form the final GRanges)
#' Source type: TXT
#' Return type: GRanges
#'
#' @name hg19.chromArm
#' @docType data
#' @keywords data
#' @usage data(hg19.chromArm, package="biscuiteer")
#'
NULL

#' hg38.chromArm
#'
#' Chromosome arm locations for hg38 genome
#'
#' Source URL: http://hgdownload.cse.ucsc.edu/goldenPath/hg38/database/cytoBand.txt.gz
#' (Chromosome arms were combined to form the final GRanges)
#' Source type: TXT
#' Return type: GRanges
#'
#' @name hg38.chromArm
#' @docType data
#' @keywords data
#' @usage data(hg38.chromArm, package="biscuiteer")
#'
NULL

#' GRCh37.chromArm
#'
#' Chromosome arm locations for GRCh37 genome
#'
#' Source URL: https://genome.ucsc.edu/cgi-bin/hgTables
#' (Cytogenic bands were retrieved using the UCSC Table Browser. The output was
#' then exported to a TXT file, where the chromosome arms were combined and
#' formed into a GRanges)
#' Source type: TXT
#' Return type: GRanges
#'
#' @name GRCh37.chromArm
#' @docType data
#' @keywords data
#' @usage data(GRCh37.chromArm, package="biscuiteer")
#'
NULL

#' GRCh38.chromArm
#'
#' Chromosome arm locations for GRCh38 genome
#'
#' Source URL: https://genome.ucsc.edu/cgi-bin/hgTables
#' (Cytogenic bands were retrieved using the UCSC Table Browser. The output was
#' then exported to a TXT file, where the chromosome arms were combined and
#' formed into a GRanges)
#' Source type: TXT
#' Return type: GRanges
#'
#' @name GRCh38.chromArm
#' @docType data
#' @keywords data
#' @usage data(GRCh38.chromArm, package="biscuiteer")
#'
NULL

#' H9state23unmeth.hg19
#'
#' Hypermethylated targets in bivalent histone sites from H9 embryonic stem
#' cells which were unmethylated across normal cells for hg19 genome
#'
#' GRanges was generated by taking the HMM-derived CpG islands (described in
#' ?HMM_CpG_islands.hg19) and overlapping with regions that were unmethylated in
#' normal H9 stem cells and had a ChromHMM state of 2 or 3 (see
#' https://www.nature.com/articles/nmeth.1906#MOESM194 for a description of
#' ChromHMM)
#' Return type: GRanges
#'
#' @name H9state23unmeth.hg19
#' @docType data
#' @keywords data
#' @usage data(H9state23unmeth.hg19, package="biscuiteer")
#'
NULL

#' H9state23unmeth.hg38
#'
#' Hypermethylated targets in bivalent histone sites from H9 embryonic stem
#' cells which were unmethylated across normal cells for hg38 genome
#'
#' GRanges was generated by taking the HMM-derived CpG islands (described in
#' ?HMM_CpG_islands.hg38) and overlapping with regions that were unmethylated in
#' normal H9 stem cells and had a ChromHMM state of 2 or 3 (see
#' https://www.nature.com/articles/nmeth.1906#MOESM194 for a description of
#' ChromHMM)
#' Return type: GRanges
#'
#' @name H9state23unmeth.hg38
#' @docType data
#' @keywords data
#' @usage data(H9state23unmeth.hg38, package="biscuiteer")
#'
NULL

#' HMM_CpG_islands.hg19
#'
#' Hidden Markov Model-derived CpG islands from hg19 genome
#'
#' Source URL: https://www.ncbi.nlm.nih.gov/pubmed/20212320
#' (Hidden Markov Model CpG islands were produced using the method described in
#' this paper. The hg19 genome was used for the CpG island production.)
#' Source type: hg19 genome and procedure described in paper
#' Return type: GRanges
#'
#' @name HMM_CpG_islands.hg19
#' @docType data
#' @keywords data
#' @usage data(HMM_CpG_islands.hg19, package="biscuiteer")
#'
NULL

#' HMM_CpG_islands.hg38
#'
#' Hidden Markov Model-derived CpG islands from hg38 genome
#'
#' Source URL: https://www.ncbi.nlm.nih.gov/pubmed/20212320
#' (Hidden Markov Model CpG islands were produced using the method described in
#' this paper. The hg19 genome was used for the CpG island production.)
#' Source type: hg19 genome and procedure described in paper
#' Return type: GRanges
#'
#' @name HMM_CpG_islands.hg38
#' @docType data
#' @keywords data
#' @usage data(HMM_CpG_islands.hg38, package="biscuiteer")
#'
NULL

#' clocks
#'
#' Epigenetic clock data
#'
#' Source: See inst/scripts/clocks.R for how the clocks data object was
#' generated. For more information about sources, see the descriptions in
#' ?getClock and ?WGBSage.
#' Return type: data.frame
#'
#' @name clocks
#' @docType data
#' @keywords data
#' @usage data(clocks, package="biscuiteer")
#'
NULL

#' seqinfo.hg19
#'
#' Seqinfo for hg19 genome
#'
#' Source URL: http://hgdownload.cse.ucsc.edu/goldenPath/hg19/bigZips/hg19.chrom.sizes
#' (The output from this site was downloaded into a TXT file and then loaded
#' into a sorted Seqinfo table)
#' Source type: TXT
#' Return type: Seqinfo
#'
#' @name seqinfo.hg19
#' @docType data
#' @keywords data
#' @usage data(seqinfo.hg19, package="biscuiteer")
#'
NULL

#' seqinfo.hg38
#'
#' Seqinfo for hg38 genome
#'
#' Source URL: http://hgdownload.cse.ucsc.edu/goldenPath/hg38/bigZips/hg38.chrom.sizes
#' (The output from this site was downloaded into a TXT file and then loaded
#' into a sorted Seqinfo table)
#' Source type: TXT
#' Return type: Seqinfo
#'
#' @name seqinfo.hg38
#' @docType data
#' @keywords data
#' @usage data(seqinfo.hg38, package="biscuiteer")
#'
NULL

#' seqinfo.mm10
#'
#' Seqinfo for mm10 genome
#'
#' Source URL: http://hgdownload.cse.ucsc.edu/goldenPath/mm10/bigZips/mm10.chrom.sizes
#' (The output from this site was downloaded into a TXT file and then loaded
#' into a sorted Seqinfo table)
#' Source type: TXT
#' Return type: Seqinfo
#'
#' @name seqinfo.mm10
#' @docType data
#' @keywords data
#' @usage data(seqinfo.mm10, package="biscuiteer")
#'
NULL
