% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eif_moderated.R
\name{modtest_ic}
\alias{modtest_ic}
\title{Moderated Statistical Tests for Influence Functions}
\usage{
modtest_ic(biotmle, adjust = "BH", pval_type = c("normal", "logistic"), ...)
}
\arguments{
\item{biotmle}{\code{biotmle} object as generated by \code{biomarkertmle}}

\item{adjust}{the multiple testing correction to be applied to p-values that
are generated from the moderated tests. The recommended (default) method
is that of Benjamini and Hochberg. See \link[limma]{topTable} for a list of
appropriate methods.}

\item{pval_type}{The reference distribution to be used for computing the
p-value. Those based on the normal approximation tend to provide misleading
inference when working with moderately sized (finite) samples. Use of the
logistic distribution has been found to empirically improve performance in
settings where multiple hypothesis testing is a concern.}

\item{...}{Other arguments passed to \code{\link[limma]{topTable}}.}
}
\value{
\code{biotmle} object containing the results of applying both
 \code{\link[limma]{lmFit}} and \code{\link[limma]{topTable}}.
}
\description{
Performs variance shrinkage via application of an empirical Bayes procedure
(of LIMMA) on the observed data after a transformation moving the data to
influence function space, based on the average treatment effect parameter.
}
\examples{
library(dplyr)
library(biotmleData)
library(SuperLearner)
library(SummarizedExperiment)
data(illuminaData)

colData(illuminaData) <- colData(illuminaData) \%>\%
  data.frame() \%>\%
  dplyr::mutate(age = as.numeric(age > median(age))) \%>\%
  DataFrame()
benz_idx <- which(names(colData(illuminaData)) \%in\% "benzene")

biomarkerTMLEout <- biomarkertmle(
  se = illuminaData[1:2, ],
  varInt = benz_idx,
  bppar_type = BiocParallel::SerialParam(),
  g_lib = c("SL.mean", "SL.glm"),
  Q_lib = c("SL.mean", "SL.glm")
)

limmaTMLEout <- modtest_ic(biotmle = biomarkerTMLEout)
}
