% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_framework.R
\name{testThat}
\alias{testThat}
\title{Run a test.}
\usage{
testThat(msg, fct, biodb = NULL, conn = NULL, opt = NULL)
}
\arguments{
\item{msg}{The test message.}

\item{fct}{The function to test.}

\item{biodb}{A valid BiodbMain instance to be passed to the test function.}

\item{conn}{A connector instance to be passed to the test function.}

\item{opt}{A set of options to pass to the test function.}
}
\value{
No value returned.
}
\description{
Run a test function, using testthat framework.
In addition to calling \code{testthat::test_that()}.
}
\examples{
# Define a context before running tests:
biodb::testContext("Test my database connector.")

# Instantiate a BiodbMain instance for testing
biodb <- biodb::createBiodbTestInstance()

# Define a test function
my_test_function <- function(biodb) {
  # Do my tests...
}

# Run test
biodb::testThat("My test works", my_test_function, biodb=biodb)

# Terminate the instance
biodb$terminate()
}
