% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiodbConfig.R
\name{BiodbConfig}
\alias{BiodbConfig}
\title{A class for storing configuration values.}
\description{
A class for storing configuration values.

A class for storing configuration values.
}
\details{
This class is responsible for storing configuration. You must go through the
single instance of this class to create and set and get configuration values.
To get the single instance of this class, call the \code{getConfig()} method
of class \code{BiodbMain}.
}
\examples{
# Create an instance with default settings:
mybiodb <- biodb::newInst()

# Get the config instance:
config <- mybiodb$getConfig()

# Print all available keys
config$getKeys()

# Get a configuration value:
value <- config$get('cache.directory')

# Set a configuration value:
config$set('dwnld.timeout', 600)

# For boolean values, you can use boolean methods:
config$get('offline')
config$enable('offline')    # set to TRUE
config$disable('offline')   # set to FALSE
config$isEnabled('offline')

# Terminate instance.
mybiodb$terminate()

}
\seealso{
\code{\link{BiodbMain}}.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BiodbConfig-new}{\code{BiodbConfig$new()}}
\item \href{#method-BiodbConfig-getKeys}{\code{BiodbConfig$getKeys()}}
\item \href{#method-BiodbConfig-getTitle}{\code{BiodbConfig$getTitle()}}
\item \href{#method-BiodbConfig-getDescription}{\code{BiodbConfig$getDescription()}}
\item \href{#method-BiodbConfig-getDefaultValue}{\code{BiodbConfig$getDefaultValue()}}
\item \href{#method-BiodbConfig-hasKey}{\code{BiodbConfig$hasKey()}}
\item \href{#method-BiodbConfig-isDefined}{\code{BiodbConfig$isDefined()}}
\item \href{#method-BiodbConfig-isEnabled}{\code{BiodbConfig$isEnabled()}}
\item \href{#method-BiodbConfig-get}{\code{BiodbConfig$get()}}
\item \href{#method-BiodbConfig-set}{\code{BiodbConfig$set()}}
\item \href{#method-BiodbConfig-reset}{\code{BiodbConfig$reset()}}
\item \href{#method-BiodbConfig-enable}{\code{BiodbConfig$enable()}}
\item \href{#method-BiodbConfig-disable}{\code{BiodbConfig$disable()}}
\item \href{#method-BiodbConfig-print}{\code{BiodbConfig$print()}}
\item \href{#method-BiodbConfig-listKeys}{\code{BiodbConfig$listKeys()}}
\item \href{#method-BiodbConfig-getAssocEnvVar}{\code{BiodbConfig$getAssocEnvVar()}}
\item \href{#method-BiodbConfig-define}{\code{BiodbConfig$define()}}
\item \href{#method-BiodbConfig-notifyNewObservers}{\code{BiodbConfig$notifyNewObservers()}}
\item \href{#method-BiodbConfig-terminate}{\code{BiodbConfig$terminate()}}
\item \href{#method-BiodbConfig-clone}{\code{BiodbConfig$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConfig-new"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConfig-new}{}}}
\subsection{Method \code{new()}}{
New instance initializer. No BiodbConfig object must not be created directly.
Instead, access the config instance through the BiodbMain instance using the
getConfig() method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConfig$new(parent)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parent}}{The BiodbMain instance.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConfig-getKeys"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConfig-getKeys}{}}}
\subsection{Method \code{getKeys()}}{
Get the list of available keys.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConfig$getKeys(deprecated = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deprecated}}{If set to TRUE returns also the deprecated keys.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character vector containing the config key names.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConfig-getTitle"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConfig-getTitle}{}}}
\subsection{Method \code{getTitle()}}{
Get the title of a key.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConfig$getTitle(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{The name of a configuration key.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The title of the key as a character value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConfig-getDescription"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConfig-getDescription}{}}}
\subsection{Method \code{getDescription()}}{
Get the description of a key.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConfig$getDescription(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{The name of a configuration key.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The description of the key as a character value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConfig-getDefaultValue"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConfig-getDefaultValue}{}}}
\subsection{Method \code{getDefaultValue()}}{
Get the default value of a key.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConfig$getDefaultValue(key, as.chr = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{The name of a configuration key.}

\item{\code{as.chr}}{If set to TRUE, returns the value as character.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The default value for that key.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConfig-hasKey"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConfig-hasKey}{}}}
\subsection{Method \code{hasKey()}}{
Test if a key exists.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConfig$hasKey(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{The name of a configuration key.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE if a key with this name exists, FALSE otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConfig-isDefined"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConfig-isDefined}{}}}
\subsection{Method \code{isDefined()}}{
Test if a key is defined (i.e.: if a value exists for this key).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConfig$isDefined(key, fail = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{The name of a configuration key.}

\item{\code{fail}}{If set to TRUE and the configuration key does not exist, then an
error will be raised.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE if the key has a value, FALSE otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConfig-isEnabled"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConfig-isEnabled}{}}}
\subsection{Method \code{isEnabled()}}{
Test if a boolean key is set to TRUE. This method will raise an error
if the key is not a boolean key.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConfig$isEnabled(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{The name of a configuration key.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE if the boolean key has a value set to TRUE, FALSE
otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConfig-get"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConfig-get}{}}}
\subsection{Method \code{get()}}{
Get the value of a key.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConfig$get(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{The name of a configuration key.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The value associated with the key.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConfig-set"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConfig-set}{}}}
\subsection{Method \code{set()}}{
Set the value of a key.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConfig$set(key, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{The name of a configuration key.}

\item{\code{value}}{A value to associate with the key.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConfig-reset"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConfig-reset}{}}}
\subsection{Method \code{reset()}}{
Reset the value of a key.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConfig$reset(key = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{The name of a configuration key. If NULL, all keys will be reset.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConfig-enable"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConfig-enable}{}}}
\subsection{Method \code{enable()}}{
Set a boolean key to TRUE.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConfig$enable(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{The name of a configuration key.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConfig-disable"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConfig-disable}{}}}
\subsection{Method \code{disable()}}{
Set a boolean key to FALSE.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConfig$disable(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{The name of a configuration key.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConfig-print"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConfig-print}{}}}
\subsection{Method \code{print()}}{
Print list of configuration keys and their values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConfig$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConfig-listKeys"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConfig-listKeys}{}}}
\subsection{Method \code{listKeys()}}{
Get the full list of keys as a data frame.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConfig$listKeys()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A data frame containing keys, titles, types, and default
values.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConfig-getAssocEnvVar"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConfig-getAssocEnvVar}{}}}
\subsection{Method \code{getAssocEnvVar()}}{
Returns the environment variable associated with this configuration
key.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConfig$getAssocEnvVar(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{The name of a configuration key.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The environment variable's value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConfig-define"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConfig-define}{}}}
\subsection{Method \code{define()}}{
Defines config properties from a structured object, normally loaded
from a YAML file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConfig$define(def)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{def}}{The list of key definitions.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConfig-notifyNewObservers"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConfig-notifyNewObservers}{}}}
\subsection{Method \code{notifyNewObservers()}}{
Called by BiodbMain when a new observer is registered.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConfig$notifyNewObservers(obs)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{obs}}{The new observers registered by the BiodbMain instance.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConfig-terminate"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConfig-terminate}{}}}
\subsection{Method \code{terminate()}}{
Terminates the instance. This method will be called
automatically by the BiodbMain instance when you call
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConfig$terminate()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{BiodbMain}}{:terminate().}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConfig-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConfig-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConfig$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
