% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_bioc_vignette.R
\name{use_bioc_vignette}
\alias{use_bioc_vignette}
\title{Create a biocthis-style vignette template}
\usage{
use_bioc_vignette(name, title = name)
}
\arguments{
\item{name}{Just like in \code{usethis::use_vignette()}: base for file name to
use for new vignette. Should consist only of numbers, letters, _ and -.
Lower case is recommended.}

\item{title}{Just like in \code{usethis::use_vignette()}: the title of the
vignette.}
}
\value{
This function adds and/or replaces the
\verb{vignettes/<name>.Rmd} file in your R package.
}
\description{
This function is very similar to \code{usethis::use_vignette()} except
that it uses a template from \code{biocthis}. This template includes
instructions for citing other packages using \code{RefManageR}, uses
\code{sessioninfo::session_info()} for displaying the R session information since
it includes GitHub installation information and other useful details. The
template also includes a section on how to ask for help and required
knowledge.
}
\examples{
\dontrun{
## Run this function in your package
pkg <- basename(usethis::proj_get())
biocthis::use_bioc_vignette(pkg, paste("Introduction to", pkg))
}

## Create an example package for illustrative purposes.
## Note: you do not need to run this for your own package!
pkgdir <- biocthis_example_pkg()

## Create a template vignette file that is Bioconductor-friendly
biocthis::use_bioc_vignette("biocthisexample", "Introduction to biocthisexample")
}
