% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnnotationFuncs.R
\name{AnnotationFuncs}
\alias{AnnotationFuncs}
\title{Annotation translation functions}
\description{
\tabular{ll}{
Package:  \tab  AnnotationFuncs\cr
Type:  \tab  Package\cr
Version:  \tab  1.3.0\cr
Date:  \tab  2011-06-10\cr
License:  \tab  GPL-2\cr
LazyLoad:  \tab  yes\cr
}
}
\details{
Functions for handling translations between different identifieres using
the Biocore Data Team data-packages (e.g. \code{org.Bt.eg.db}).
Primary functions are \code{\link{translate}} for translating
and \code{\link{getOrthologs}} for efficient lookup of homologes
using the Inparanoid databases.
Other functions include functions for selecting Refseqs or Gene Ontologies (GO).
}
\examples{
library(org.Bt.eg.db)
gene.symbols <- c('DRBP1','SERPINA1','FAKE','BLABLA')
# Find entrez identifiers of these genes.
eg <- translate(gene.symbols, org.Bt.egSYMBOL2EG)
# Note that not all symbols were translated.

# Go directly to Refseq identifiers.
refseq <- translate(gene.symbols, from=org.Bt.egSYMBOL2EG, to=org.Bt.egREFSEQ)
# Pick the proteins:
 pickRefSeq(refseq, priorities=c('NP','XP'), reduce='all')
}
\references{
\url{https://www.iysik.com/index.php?page=annotation-functions}
}
\seealso{
\code{\link{translate}}, \code{\link{getOrthologs}}
}
\author{
Stefan McKinnon Edwards  \email{stefan.hoj-edwards@agrsci.dk}
}
\keyword{package}
