% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedbaser.R
\name{BEDbase}
\alias{BEDbase}
\alias{getCache}
\alias{setCache}
\title{An R client for BEDbase}
\usage{
BEDbase(cache_path, quietly = FALSE)

getCache(x, cache_type = c("bedfiles", "bedsets"))

setCache(x, cache_path, quietly = TRUE)
}
\arguments{
\item{cache_path}{character(1)}

\item{quietly}{logical(1) (default \code{TRUE}) display messages}

\item{x}{BEDbase() object}

\item{cache_type}{character(1) bedfiles or bedsets}
}
\value{
BEDbase object
}
\description{
bedbaser exposes the \href{https://api.bedbase.org}{bedhost API}
and includes convenience functions for common tasks, such as to import a
BED file by \code{id} into a GRanges object and a BEDset by its \code{id} into a
GRangesList.
}
\details{
\code{BEDbase()} creates a cache similar to that of the
\href{https://docs.bedbase.org/geniml}{Geniml BBClient's cache}.

The convenience functions are as follows
\itemize{
\item \code{bedbaser::BEDbase()}: API service constructor
\item \code{bedbaser::getCache()}: Retrieve cache
\item \code{bedbaser::setCache()}: Set path to cache
\item \code{bedbaser::bb_stats()}: Retrieve BEDbase statistics
\item \code{bedbaser::bb_example()}: Retrieve an example BED file or BEDset
\item \code{bedbaser::bb_metadata()}: Retrieve metadata for a BED file or BEDset
\item \code{bedbaser::bb_list_beds()}: List all BED files
\item \code{bedbaser::bb_list_bedsets()}: List all BEDsets
\item \code{bedbaser::bb_beds_in_bedset()}: List BED files in BEDset
\item \code{bedbaser::bb_bed_text_search()}: Search BED files by text
\item \code{bedbaser::bb_to_granges()}: Create a GRanges object from a BED id
\item \code{bedbaser::bb_to_grangeslist()}: Create a GRangesList from a BEDset id
\item \code{bedbaser::bb_save()}: Save a BED file to a path.
}
}
\examples{
bedbase <- BEDbase(cache_path = tempdir())
ex_bed <- bb_example(bedbase, "bed")
bb_metadata(bedbase, ex_bed$id)

}
