% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PRIOR_FUNCTIONS.R
\name{BetaFun}
\alias{BetaFun}
\title{Estimate capture efficiency for cells}
\usage{
BetaFun(Data, MeanBETA)
}
\arguments{
\item{Data}{A matrix of single-cell expression where rows
are genes and columns are samples (cells). \code{Data}
can be of class \code{SummarizedExperiment} (the
assays slot contains the expression matrix,
is named "Counts"), just \code{matrix} or sparse matrix.}

\item{MeanBETA}{Mean capture efficiency of the scRNAseq data.
This can be estimated via spike-ins or other methods.}
}
\value{
List containing: \code{BETA}: a vector of capture efficiencies,
 which is of length number of cells;
 \code{Selected_genes}: a subset of
  genes that are used for estimating BETA.
}
\description{
This function estimates cell specific
capture efficiencies (\code{BETA_vec}) using mean raw counts of
a subset of genes that is an input for bayNorm. A specific
method is used to exclude genes with high expression or high
drop-out are excluded.
}
\examples{
data('EXAMPLE_DATA_list')
BETA_out<-BetaFun(Data=EXAMPLE_DATA_list$inputdata,
MeanBETA=0.06)
}
