% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lockExternalDir.R
\name{lockExternalDir}
\alias{lockExternalDir}
\alias{unlockExternalDir}
\title{Lock external directory}
\usage{
lockExternalDir(path = getExternalDir(), ...)

unlockExternalDir(lock.info, ...)
}
\arguments{
\item{path}{String containing the path to the external directory.}

\item{...}{For \code{lockExternalDir}, further arguments to pass to \code{\link[dir.expiry]{lockDirectory}} such as \code{exclusive}.
For \code{unlockExternalDir}, further arguments to pass to \code{\link[dir.expiry]{unlockDirectory}} such as \code{clear}.}

\item{lock.info}{A lock object generated by \code{\link[dir.expiry]{lockDirectory}}.}
}
\value{
\code{lockExternalDir} will return a lock object from \code{\link[dir.expiry]{lockDirectory}}.

\code{unlockExternalDir} will unlock the file and return \code{NULL} invisibly.
}
\description{
Lock the external directory so that multiple processes cannot try to create environments at the same time.
}
\details{
This will apply a lock to the (possibly user-specified) external environment directory,
so that a user trying to run parallel \pkg{basilisk} processes will not have race conditions during lazy environment creation.
We use \pkg{dir.expiry} to manage the locking process for us, with the following strategy:
\itemize{
\item If a system installation is being performed, we do not perform any locking.
Rather, the R package manager will lock the entire R installation directory for us.
\item If the external directory is not yet present, we establish an exclusive lock and create that directory.
\item If an external installation directory is already present, we establish a shared lock.
This will wait for any exclusive lock to expire (and thus any currently running installation to finish).
No waiting is required if there are no existing exclusive locks.
}

Note that locking is only required during the creation of virtual environments, not during their actual use.
Once an environment is created, we assume that it is read-only for all processes.
}
\examples{
loc <- lockExternalDir()
unlockExternalDir(loc)

}
\author{
Aaron Lun
}
