% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processIlluminaSamplesheets_Functions.R
\docType{methods}
\name{createBCLcommand}
\alias{createBCLcommand}
\title{Function to create command for Illumina basecalling/demultiplexing using bcl2fastq versions >= 2.1.7.}
\usage{
createBCLcommand(bcl2fastqparams, cleanedSampleSheet, baseMasks)
}
\arguments{
\item{bcl2fastqparams}{A BCL2FastQparams object.}

\item{cleanedSampleSheet}{Data.frame of cleaned samplesheet for Illumina basecalling/demultiplexing using bcl2fastq versions >= 2.1.7 (see vignette for more details)}

\item{baseMasks}{A data.frame of basemasks as created by createBasemasks() function}
}
\value{
A character vector containing the command for Illumina basecalling using bcl2fastq versions >= 2.1.7
}
\description{
Creates the command to be used for basecalling/demultiplexing with bcl2fastq versions >= 2.1.7
}
\examples{

fileLocations <- system.file("extdata",package="basecallQC")
runXML <- dir(fileLocations,pattern="runParameters.xml",full.names=TRUE)
config <- dir(fileLocations,pattern="config.ini",full.names=TRUE)
sampleSheet <- dir(fileLocations,pattern="*\\\\.csv",full.names=TRUE)
bcl2fastqparams <- BCL2FastQparams(runXML,config,runDir=getwd(),verbose=FALSE)

cleanedSampleSheet <- validateBCLSheet(sampleSheet,param=bcl2fastqparams)
baseMasks <- createBasemasks(cleanedSampleSheet,param=bcl2fastqparams)
toSubmit <- createBCLcommand(bcl2fastqparams,cleanedSampleSheet,baseMasks)
}
\author{
Thomas Carroll and Marian Dore
}
