% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allClasses.R
\docType{class}
\name{basecallQC-class}
\alias{basecallQC-class}
\alias{basecallQC}
\alias{basecallQC-basecallQC}
\alias{basecallQC}
\title{The basecallQC object and constructor.}
\usage{
basecallQC(bcl2fastqparams, RunMetaData = NULL, sampleSheet = NULL,
  doFQMetric = FALSE)
}
\arguments{
\item{bcl2fastqparams}{A BCL2FastQparams object as created by BCL2FastQparams() constructor.}

\item{RunMetaData}{Any run metadata to attach (data.frame)}

\item{sampleSheet}{A sample sheet for Illumina basecalling using bcl2Fastq (See vignette for more details).}

\item{doFQMetric}{TRUE or FALSE. Perform ShortRead FastQ quality assessment
using ShortRead's qa and report function}
}
\value{
basecallQC a basecallQC object (See details for more information)
}
\description{
Object and method to handle Illumina basecalling/demultiplexing
inputs and output files.
Provides sample sheet cleanup, basecall command and
summary QC statistics for basecalling/demultiplexing.

The basecallQC object and constructor.
}
\details{
The basecallQC object contains slots BCL2FastQparams,
 cleanedSampleSheet, baseMasks, BCLCommand, baseCallMetrics, demultiplexMetrics and fqQCmetrics.
\itemize{
\item{"BCL2FastQparams"}{ A BCL2FastQparams object}
\item{"cleanedSampleSheet"}{ A data.frame containing the cleaned sample sheet for
 Illumina basecalling using bcl2Fastq versions >= 2.1.7
}
\item{"baseMasks"}{ A data.frame containing basecall masks per lane for use with bcl2Fastq versions >= 2.1.7. Basemasks in data.frame for reads and indexes as well as the total basemasks for each lane.
}
\item{"BCLCommand"}{ A character string containing the command to be used for basecalling using bcl2Fastq (versions >= 2.1.7).
}
\item{"baseCallMetrics"}{ A list containing the full basecalling metrics from ConversionStats.xml. Contains an unsummarised data.frame and basecalling metrics summarised to Sample, Lane, Sample by lane, and Sample by Lane and Tile
}
\item{"demultiplexMetrics"}{ A list containing the full demultiplexing metrics from DemultiplexingStats.xml. Contains an unsummarised data.frame and demultiplexing metrics filtered to per Sample metrics
}
\item{"fqQCmetrics"}{ A list containing a data.frame of read counts and links to ShortRead QA reports and a ShortRead QA object containing quality information for generated fastQs.
}
}
}
\examples{
fileLocations <- system.file("extdata",package="basecallQC")
runXML <- dir(fileLocations,pattern="runParameters.xml",full.names=TRUE)
config <- dir(fileLocations,pattern="config.ini",full.names=TRUE)
sampleSheet <- dir(fileLocations,pattern="*\\\\.csv",full.names=TRUE)
outDir <- file.path(fileLocations,"Runs/161105_D00467_0205_AC9L0AANXX/C9L0AANXX/")
bcl2fastqparams <- BCL2FastQparams(runXML,config,runDir=getwd(),outDir,verbose=FALSE)
bclQC <- basecallQC(bcl2fastqparams,RunMetaData=NULL,sampleSheet)
}
