% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandle-utils.R
\name{calculateGelman}
\alias{calculateGelman}
\title{Calculate the Gelman and Rubin diagnostic for bandle output}
\usage{
calculateGelman(params)
}
\arguments{
\item{params}{An instance of class \code{bandleParams}}
}
\value{
A \code{list} of 2 \code{matrix} \code{array}'s, one for each
condition containing the point estimates of the potential scale reduction
factor (labelled Point est.) and their upper confidence limits (labelled
Upper C.I.).
}
\description{
This function is a wrapper function for the \code{gelman.diag} function from
the \code{coda} package. It takes a \code{bandleParams} object and
calculates the Gelman and Rubin's convergence diagnostic (otherwise known as
the potential scale reduction factor) for all pairwise MCMC chain
combinations, together with upper and lower confidence limits.
}
\examples{
## Generate some example data
library("pRolocdata")
data("tan2009r1")
set.seed(1)
tansim <- sim_dynamic(object = tan2009r1,
                      numRep = 4L,
                      numDyn = 100L)
data <- tansim$lopitrep
control <- data[1:2]
treatment <- data[3:4]

## fit GP params
gpParams <- lapply(tansim$lopitrep, function(x)
fitGPmaternPC(x, hyppar = matrix(c(0.5, 1, 100), nrow = 1)))

## run bandle
res <- bandle(objectCond1 = control,
              objectCond2 = treatment,
              gpParams = gpParams,
              fcol = "markers",
              numIter = 20L,
              burnin = 1L,
              thin = 2L,
              numChains = 2,
              BPPARAM = SerialParam(RNGseed = 1),
              seed = 1)

## Process the results
calculateGelman(res)
}
