% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BaconClass.R, R/BaconMethods.R
\name{pval}
\alias{pval}
\alias{pval,Bacon-method}
\title{Method to extract inflation- and bias-corrected P-values}
\usage{
pval(object, corrected = TRUE)

\S4method{pval}{Bacon}(object, corrected = TRUE)
}
\arguments{
\item{object}{'bacon'-object}

\item{corrected}{optional return uncorrected}
}
\value{
vector or matrix of P-values
}
\description{
Method to extract inflation- and bias-corrected P-values
}
\examples{
y <- rnormmix(2000, c(0.9, 0, 1, 0, 4, 1))
bc <- bacon(y, nbins=100) #nbins = 100 to speed up the calculations
head(pval(bc))
}
\seealso{
\code{\link{bacon}}
}
