% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/17_read_compounddiscoverer.R
\name{read_compounddiscoverer}
\alias{read_compounddiscoverer}
\title{Read compound discoverer output}
\usage{
read_compounddiscoverer(
  dir = getwd(),
  files = list.files(path = dir, pattern = "(RP|HILIC).*\\\\.csv$", full.names = TRUE),
  colname_regex = "^(.*)\\\\d{8,8}_+(.*)_+((HILIC|RP)(NEG|POS))\\\\.raw.*$",
  colname_format = function(x) stringi::stri_replace_first_regex(x, colname_regex,
    "$1$2", opts_regex = stringi::stri_opts_regex(case_insensitive = TRUE)),
  mod_extract = function(x) stringi::stri_subset_regex(x, colname_regex, opts_regex =
    stringi::stri_opts_regex(case_insensitive = TRUE)) \%>\%
    stringi::stri_replace_first_regex(colname_regex, "$3", opts_regex =
    stringi::stri_opts_regex(case_insensitive = TRUE)),
  quantity = NULL,
  nonames = FALSE,
  exclude_sname_pattern = "(blank|QC|RS)",
  subgroups = NULL,
  logbase = 2,
  impute = FALSE,
  plot = FALSE,
  label = "feature_id",
  pca = plot,
  pls = plot,
  fit = if (plot) "limma" else NULL,
  formula = ~subgroup,
  block = NULL,
  coefs = NULL,
  contrasts = NULL,
  palette = NULL,
  verbose = TRUE
)
}
\arguments{
\item{dir}{compound discoverer output directory}

\item{files}{compound discoverer output files}

\item{colname_regex}{regular expression to parse sample names from column names}

\item{colname_format}{function to reformat column names}

\item{mod_extract}{function to extract MS modi from sample names}

\item{quantity}{'area', 'normalizedarea' or NULL}

\item{nonames}{TRUE or FALSE: retain compunds without Names?}

\item{exclude_sname_pattern}{regular expression of sample names to exclude}

\item{subgroups}{NULL or string vector : subgroups to retain}

\item{logbase}{base for logarithmization of the data}

\item{impute}{TRUE or FALSE: impute group-specific NA values?}

\item{plot}{TRUE or FALSE: plot ?}

\item{label}{fvar}

\item{pca}{TRUE or FALSE: run pca ?}

\item{pls}{TRUE or FALSE: run pls ?}

\item{fit}{model engine: 'limma', 'lm', 'lme(r)', 'wilcoxon' or NULL}

\item{formula}{model formula}

\item{block}{model blockvar: string or NULL}

\item{coefs}{model coefficients    of interest: character vector or NULL}

\item{contrasts}{coefficient contrasts of interest: character vector or NULL}

\item{palette}{color palette : named character vector}

\item{verbose}{TRUE or FALSE : message ?}
}
\value{
SummarizedExperiment
}
\description{
Read compound discoverer output
}
