% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/18_mixmod_bin_densities.R
\name{factorize}
\alias{factorize}
\alias{factorize.logical}
\alias{factorize.character}
\alias{factorize.factor}
\alias{factorize.numeric}
\alias{factorize.matrix}
\alias{factorize.SummarizedExperiment}
\alias{factorize_assay}
\alias{bin}
\alias{bin.logical}
\alias{bin.character}
\alias{bin.factor}
\alias{bin.numeric}
\alias{bin.matrix}
\alias{bin.SummarizedExperiment}
\alias{bin_assay}
\title{Factorize/Bin}
\usage{
factorize(x, ...)

\method{factorize}{logical}(x, ...)

\method{factorize}{character}(x, ...)

\method{factorize}{factor}(x, ...)

\method{factorize}{numeric}(
  x,
  method = "quantile",
  k = switch(method, quantile = 3, mclust = NULL, mixtools = 3),
  numericlevels = TRUE,
  ...
)

\method{factorize}{matrix}(
  x,
  method = "quantile",
  k = switch(method, quantile = 3, mclust = NULL, mixtools = 3),
  numericlevels = TRUE,
  ...
)

\method{factorize}{SummarizedExperiment}(
  x,
  assay = assayNames(x)[1],
  method = "quantile",
  k = switch(method, quantile = 3, mclust = NULL, mixtools = 3),
  numericlevels = TRUE,
  drop = TRUE,
  verbose = TRUE,
  ...
)

factorize_assay(
  x,
  assay = assayNames(x)[1],
  method = "quantile",
  k = switch(method, quantile = 3, mclust = NULL, mixtools = 3),
  verbose = TRUE,
  ...
)

bin(x, ...)

\method{bin}{logical}(x, ...)

\method{bin}{character}(x, ...)

\method{bin}{factor}(x, ...)

\method{bin}{numeric}(
  x,
  method = "quantile",
  k = switch(method, quantile = 3, mclust = NULL, mixtools = 3),
  numericlevels = TRUE,
  ...
)

\method{bin}{matrix}(
  x,
  method = "quantile",
  k = switch(method, quantile = 3, mclust = NULL, mixtools = 3),
  numericlevels = TRUE,
  ...
)

\method{bin}{SummarizedExperiment}(
  x,
  assay = assayNames(x)[1],
  method = "quantile",
  k = switch(method, quantile = 3, mclust = NULL, mixtools = 3),
  verbose = TRUE,
  ...
)

bin_assay(
  x,
  assay = assayNames(x)[1],
  method = "quantile",
  k = switch(method, quantile = 3, mclust = NULL, mixtools = 3),
  verbose = TRUE
)
}
\arguments{
\item{x}{vector, matrix or SummarizedExperiment}

\item{...}{(S3 dispatch)}

\item{method}{'quantile', 'mclust', or 'mixtools'}

\item{k}{number of bins/levels}

\item{numericlevels}{TRUE (levels: 1,2, ...) or FALSE (levels: 2.1+, 3.2+, ...)}

\item{assay}{string}

\item{drop}{whether to drop assayname in levels ('1','2') or not ('exprs1', 'exprs2') when factorizing}

\item{verbose}{TRUE or FALSE}
}
\value{
vector, matrix or SummarizedExperiment
}
\description{
Factorize/Bin
}
\details{
`bin` transform into numeric bins : c(1,2,3,4,5,6) -> c( 1,  1,  2,  2,  3,  3 )
   `factorize` transform into factor levels: c(1,2,3,4,5,6) -> c('1','1','2','2','3','3')
}
\examples{
# data 
    file <- system.file('extdata/fukuda20.proteingroups.txt', package = 'autonomics')
    object <- read_maxquant_proteingroups(file, impute = TRUE)
    fdt(object)

# logical
    fdt(object)$imputed
    fdt(object)$imputed \%>\% factorize()
    fdt(object)$imputed \%>\% bin()
    
# character
    as.character(fdt(object)$imputed)
    as.character(fdt(object)$imputed) \%>\% factorize()
    as.character(fdt(object)$imputed) \%>\% bin()

# factor
    factor(fdt(object)$imputed)
    factor(fdt(object)$imputed) \%>\% factorize()
    factor(fdt(object)$imputed) \%>\% bin()
    
# numeric
    fdt(object)$pepcounts
    fdt(object)$pepcounts \%>\% factorize()
    fdt(object)$pepcounts \%>\% bin()

# Matrix/SummarizedExperiment
    values(object)
    values(object) \%>\% factorize()
           object  \%>\% factorize()
    values(object) \%>\% bin()
           object  \%>\% bin()
}
