% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/22_transform.R
\name{plot_densities_transforms}
\alias{plot_densities_transforms}
\alias{plot_violins_transforms}
\alias{biplot_transforms}
\alias{biplot_transforms_assays}
\title{Visually evaluate transformation effects}
\usage{
plot_densities_transforms(
  object,
  assay = assayNames(object)[1],
  subgroupvar = "subgroup",
  transforms = c("center", "invnorm", "quantnorm", "vsn", "zscore"),
  ...,
  fixed = list(na.rm = TRUE, show.legend = FALSE, verbose = FALSE),
  verbose = TRUE
)

plot_violins_transforms(
  object,
  assay = assayNames(object)[1],
  subgroupvar = "subgroup",
  transforms = c("center", "invnorm", "quantnorm", "vsn", "zscore"),
  ...,
  fixed = list(na.rm = TRUE, trim = FALSE, draw_quantiles = c(0.25, 0.5, 0.75),
    show.legend = FALSE),
  verbose = TRUE
)

biplot_transforms(
  object,
  assay = assayNames(object)[1],
  subgroupvar = "subgroup",
  transforms = TRANSFORMSTRICT,
  method = DIMREDENGINES[1],
  dims = 1:2,
  color = subgroupvar,
  shape = NULL,
  size = NULL,
  alpha = NULL,
  group = NULL,
  label = NULL,
  ncol = NULL,
  nrow = NULL,
  ...,
  fixed = list(shape = 15, size = 3),
  verbose = FALSE
)

biplot_transforms_assays(
  object,
  assays = assayNames(object)[1],
  subgroupvar = "subgroup",
  transforms = TRANSFORMSTRICT,
  method = DIMREDENGINES[1],
  dims = 1:2,
  color = subgroupvar,
  shape = NULL,
  size = NULL,
  alpha = NULL,
  group = NULL,
  label = NULL,
  ...,
  verbose = FALSE,
  fixed = list(shape = 15, size = 3)
)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{assay}{string           : assay name to operate on}

\item{subgroupvar}{svar}

\item{transforms}{character vector : transformations explored}

\item{...}{: further plotting parameters}

\item{fixed}{list             : fixed  aesthetics}

\item{verbose}{TRUE/FALSE       : message?}

\item{method}{string           : dimension reduction technique}

\item{dims}{numbers          : biplot dimensions}

\item{color}{svar}

\item{shape}{svar}

\item{size}{svar}

\item{alpha}{svar}

\item{group}{svar}

\item{label}{svar}

\item{ncol}{integer          : columns for facet wraping}

\item{nrow}{integer          : rows for facet wraping}

\item{assays}{character vector : assay names to operate on}
}
\value{
ggplot2 object
}
\description{
Visually evaluate transformation effects
}
\examples{
file <- system.file('extdata/fukuda20.proteingroups.txt', package = 'autonomics')
object <- read_maxquant_proteingroups(file)

# `vsn` implemented, but example data set to small
transformations <- c(
  'center_mean', 'center_median', 'invnorm', 'quantnorm', 'zscore')

# object \%>\% plot_densities_transforms(transforms = transformations) # Requires package ggridges
object \%>\% plot_violins_transforms(transforms = transformations)

object \%>\% biplot_transforms(
  method  = 'pca', transforms = transformations, nrow = 2)
object \%>\% biplot_transforms(
  method  = 'pls', transforms = transformations, nrow = 2)
  
object[['replicate']] <- gsub('^.*\\\\.(.+)$', '\\\\1', object[['sample_id']])
object \%>\%
  biplot_transforms(
  transforms = transformations, label = 'replicate')
}
\author{
Johannes Graumann
}
