% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/24_linmod.R
\name{contrastdt}
\alias{contrastdt}
\title{Get contrastdt}
\usage{
contrastdt(
  object,
  fitcoef,
  annocols = fvars(object) \%>\% extract(!stri_detect_fixed(., "~")),
  assays = assayNames(object)[0],
  verbose = TRUE
)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{fitcoef}{e.g. 't2-t1~limma'}

\item{annocols}{annotation fvars}

\item{assays}{subset of assayNames(object)}

\item{verbose}{TRUE or FALSE}
}
\value{
data.table
}
\description{
Get contrastdt
}
\examples{
object <- survobj()
object \%<>\% linmod_limma(~sex/age)
contrastdt(object,        fitcoef = 'm:senior-junior~limma')
contrastdt(object[, 1:2], fitcoef = 'm:senior-junior~limma', assays = SummarizedExperiment::assayNames(object)[1])
contrastdt(object[, 1:2], fitcoef = 'm:senior-junior~limma', assays = SummarizedExperiment::assayNames(object)[1:2])
}
