% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/26_linmod_lmx.R
\name{block2lmer}
\alias{block2lmer}
\alias{block2lmer.formula}
\alias{block2lmer.character}
\alias{block2lmer.list}
\title{block2lmer}
\usage{
block2lmer(block, formula, ...)

\method{block2lmer}{formula}(block, formula = NULL, ...)

\method{block2lmer}{character}(block, formula = NULL, ...)

\method{block2lmer}{list}(block, formula = NULL, ...)
}
\arguments{
\item{block}{block: charactervector or formula}

\item{formula}{model formula}

\item{...}{required for s3 dispatch}
}
\description{
block2lmer
}
\examples{
block2lmer( block = c('subject', 'batch'))
block2lmer( block = c('subject', 'batch'), formula = ~ subgroup)

block2lmer( block = c(`1`= 'subject', `1`= 'batch'))
block2lmer( block = c(`1`= 'subject', `1`= 'batch'),   formula = ~ subgroup)

block2lmer( block = ~(1|subject)  +  (1|batch))
block2lmer( block = ~(1|subject)  +  (1|batch),        formula = ~ subgroup)

block2lmer( block = list(subject = ~1,   batch = ~1 ))
block2lmer( block = list(subject = ~1,   batch = ~1 ), formula = ~ subgroup)
}
