% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/25_linmod_limma.R
\name{X}
\alias{X}
\alias{beta}
\title{Model based prediction}
\usage{
X(
  object,
  formula = default_formula(object),
  drop = varlevels_dont_clash(object, all.vars(formula)),
  coding = "code_control"
)

beta(object, fit = fits(object)[1])
}
\arguments{
\item{object}{SummarizedExperiment or data.frame}

\item{formula}{formula}

\item{drop}{TRUE or FALSE}

\item{coding}{string: codingfunname}

\item{fit}{'limma', 'lm', 'lme', 'wilcoxon'}
}
\value{
beta matrix (nlevel x nfeature)
}
\description{
Model based prediction
}
\examples{
file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
object <- read_metabolon(file)
object \%<>\% linmod_limma(block = 'Subject', coefs = model_coefs(object)) # intercept required!
beta(object)                    #    betas : nlevel x nfeature
   X(object)                    #   design : nlevel x nlevel
   X(object) \%*\% beta(object)   # response : nlevel x nfeature
}
