% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{artmsPlotHeatmapQuant}
\alias{artmsPlotHeatmapQuant}
\title{Outputs a heatmap of the MSStats results created using the log2fold
changes}
\usage{
artmsPlotHeatmapQuant(
  input_file,
  output_file = "quantifications_heatmap.pdf",
  species,
  labels = "*",
  cluster_cols = FALSE,
  display = "log2FC",
  lfc_lower = -2,
  lfc_upper = 2,
  whatPvalue = "adj.pvalue",
  FDR = 0.05,
  verbose = TRUE
)
}
\arguments{
\item{input_file}{(char) MSstats \code{results.txt} file and location (or
data.frame of resuts)}

\item{output_file}{(char) Output file name (pdf format) and location.
Default:"quantifications_heatmap.pdf"}

\item{species}{(char). Specie name to be able to add the Gene name. To find
out more about the supported species check \code{?artmsMapUniprot2Entrez}}

\item{labels}{(vector) of uniprot ids if only specific labes would like to
be plotted. Default: all labels}

\item{cluster_cols}{(boolean) \code{True} or \code{False} to cluster columns.
Default: FALSE}

\item{display}{Metric to be displayed. Options:
\itemize{
\item \code{log2fc} (default)
\item \code{adj.pvalue}
\item \code{pvalue}
}}

\item{lfc_lower}{(int) Lower limit for the log2fc. Default: -2}

\item{lfc_upper}{(int) Upper limit for the log2fc. Default: +2}

\item{whatPvalue}{(char) \code{pvalue} or \code{adj.pvalue} (default)}

\item{FDR}{(int) Upper limit false discovery rate (or pvalue). Default: 0.05}

\item{verbose}{(logical) \code{TRUE} (default) shows function messages}
}
\value{
(pdf or ggplot2 object) heatmap of the MSStats results using the
selected metric
}
\description{
Heatmap of the Relative Quantifications (MSStats results)
}
\examples{
# Unfortunately, the example does not contain any significant hits
# Use for illustration purposes
artmsPlotHeatmapQuant(input_file = artms_data_ph_msstats_results,
                       species = "human",
                       output_file = NULL,
                       whatPvalue = "pvalue",
                       lfc_lower = -1,
                       lfc_upper = 1)
}
\keyword{heatmap,}
\keyword{log2fc}
