% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysisQuantifications.R
\name{artmsAnalysisQuantifications}
\alias{artmsAnalysisQuantifications}
\title{Analysis of the Relative Quantifications}
\usage{
artmsAnalysisQuantifications(
  log2fc_file,
  modelqc_file,
  species,
  output_dir = "analysis_quant",
  outliers = c("keep", "iqr", "std"),
  enrich = TRUE,
  l2fc_thres = 1,
  choosePvalue = c("adjpvalue", "pvalue"),
  isBackground = "nobackground",
  isPtm = "global",
  mnbr = 2,
  pathogen = "nopathogen",
  plotPvaluesLog2fcDist = TRUE,
  plotAbundanceStats = TRUE,
  plotReproAbundance = TRUE,
  plotCorrConditions = TRUE,
  plotCorrQuant = TRUE,
  plotPCAabundance = TRUE,
  plotFinalDistributions = TRUE,
  plotPropImputation = TRUE,
  plotHeatmapsChanges = TRUE,
  plotTotalQuant = TRUE,
  plotClusteringAnalysis = TRUE,
  data_object = FALSE,
  printPDF = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{log2fc_file}{(char) MSstats results file location}

\item{modelqc_file}{(char) MSstats modelqc file location}

\item{species}{(char) Select one species. Species currently supported for
a full analysis (including enrichment analysis):
\itemize{
\item HUMAN
\item MOUSE
To find out species supported only for annotation check
\code{?artmsIsSpeciesSupported()}
}}

\item{output_dir}{(char) Name for the folder to output the results from the
function. Default is current directory (recommended to provide a new folder
name).}

\item{outliers}{(char) It allows to keep or remove outliers. Options:
\itemize{
\item \code{keep} (default): it keeps outliers 'keep', 'iqr', 'std'
\item \code{iqr} (recommended): remove outliers +/- 6 x Interquartile Range (IQR)
\item \code{std} : 6 x standard deviation
}}

\item{enrich}{(logical) Performed enrichment analysis using GprofileR?
Only available for species HUMAN and MOUSE.
\code{TRUE} (default if "human" or "mouse" are the species) or \code{FALSE}}

\item{l2fc_thres}{(int) log2fc cutoff for enrichment analysis (default,
\code{l2fc_thres = 1.5})}

\item{choosePvalue}{(char) specify whether \code{pvalue} or \code{adjpvalue} should
use for the analysis. The default option is \code{adjpvalue}
(multiple testing correction).
But if the number of biological replicates for a given experiment is
too low (for example n = 2), then \code{choosePvalue = pvalue} is recommended.}

\item{isBackground}{(char) background of gene names for enrichment analysis.
\code{nobackground} (default) will use the total number of genes detected.
Alternatively provided the file path name to the background gene list.}

\item{isPtm}{(char) Is a ptm-site quantification?
\itemize{
\item \code{global} (default),
\item \code{ptmsites} (for site specific analysis),
\item \code{ptmph} (Jeff Johnson script output evidence file)
}}

\item{mnbr}{(int) \strong{PARAMETER FOR NAIVE IMPUTATION}:
"minimal number of biological replicates" for "naive
imputation" and filtering. Default: \code{mnbr = 2}. Details:
Intensity values for proteins/PTMs that are completely missed in one
of the two conditions compared ("condition A"), but are found in
at least 2 biological replicates (\code{mnbr = 2}) of the other "condition B",
are imputed (values artificially assigned) and the log2FC values calculated.
The goal is to keep those proteins/PTMs that are consistently found in
one of the two conditions (in this case "condition B") and facilitate the
inclusion in downstream analysis (if wished). The imputed intensity values
are sampled from the lowest intensity values detected in the experiment,
and (\strong{WARNING}) the p-values are just randomly assigned between
0.05 and 0.01 for illustration purposes (when generating a volcano
plot with the output of \code{artmsAnalysisQuantifications}) or to include
them when making a cutoff of p-value < 0.05 for enrichment analysis
\strong{CAUTION}: \code{mnbr} would also add the constraint that any protein
must be identified in at least \code{nmbr} biological replicates of the
\strong{same} condition or it will be filtered out. That is,
if \code{mnbr = 2}, a protein found in two conditions but only in one
biological replicate in each of them, it would be removed.}

\item{pathogen}{(char) Is there a pathogen in the dataset as well?
if it does not, then use \code{pathogen = nopathogen} (default).
Pathogens available: \code{tb} (Tuberculosis), \code{lpn} (Legionella)}

\item{plotPvaluesLog2fcDist}{(logical) If \code{TRUE} (default) plots pvalues
and log2fc distributions}

\item{plotAbundanceStats}{(logical) If \code{TRUE} (default) plots stats graphs
about abundance values}

\item{plotReproAbundance}{(logical) If \code{TRUE} plots reproducibility
based on normalized abundance values}

\item{plotCorrConditions}{(logical) If \code{TRUE} plots correlation
between the different conditions}

\item{plotCorrQuant}{(logical) if \code{TRUE} plots correlation between the
available quantifications (comparisons)}

\item{plotPCAabundance}{(logical) if \code{TRUE} performs PCA analysis of
conditions using normalized abundance values}

\item{plotFinalDistributions}{(logical) if \code{TRUE} plots distribution of both
log2fc and pvalues}

\item{plotPropImputation}{(logical) if \code{TRUE} plots proportion of overall
imputation}

\item{plotHeatmapsChanges}{(logical) if \code{TRUE} plots heatmaps of quantified
changes (both all and significant only). Only if \code{printPDF} is also \code{TRUE}}

\item{plotTotalQuant}{(logical) if \code{TRUE} plots barplot of total number of
quantifications per comparison}

\item{plotClusteringAnalysis}{(logical) if \code{TRUE} performs clustering
analysis between quantified comparisons (more than 1 comparison required)}

\item{data_object}{(logical) flag to indicate whether the required files
are data objects. Default is FALSE}

\item{printPDF}{If \code{TRUE} (default) prints out the pdfs. Warning: plot
objects are not returned due to the large number of them.}

\item{verbose}{(logical) \code{TRUE} (default) shows function messages}
}
\value{
(data.frame) summary of quantifications, including annotations,
enrichments, etc
}
\description{
Analysis of relative quantifications, including:
\itemize{
\item Annotations
\item Summary files in different format (xls, txt) and shapes (long, wide)
\item Numerous summary plots
\item Enrichment analysis using Gprofiler
\item PCA of quantifications
\item Clustering analysis
\item Basic imputation of missing values
}

To run this function, the following packages must be installed on your system:
\itemize{
\item From bioconductor:
\code{BiocManager::install(c("ComplexHeatmap", "org.Mm.eg.db"))}
\item From CRAN:
\code{install.packages(c("factoextra", "FactoMineR", "gProfileR", "PerformanceAnalytics"))}
}
}
\examples{
# Testing that the files cannot be empty
artmsAnalysisQuantifications(log2fc_file = NULL,
                              modelqc_file = NULL,
                              species = NULL,
                              output_dir = NULL)
}
\keyword{analysis,}
\keyword{quantifications}
