% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anota2seqAllGenerics.R, R/anota2seqMethods.R
\docType{methods}
\name{anota2seqGetOutput}
\alias{anota2seqGetOutput}
\alias{anota2seqGetOutput,Anota2seqDataSet-method}
\title{Retrieve output for analyzes stored in the Anota2seqDataSet}
\usage{
anota2seqGetOutput(object, analysis, output, selContrast, getRVM = TRUE)

\S4method{anota2seqGetOutput}{Anota2seqDataSet}(object, analysis, output, 
  selContrast, getRVM = TRUE)
}
\arguments{
\item{object}{An Anota2seqDataSet}

\item{analysis}{A character string that can be "translated mRNA", "total 
mRNA", "translation", "buffering" or "mRNA abundance". This parameter is not needed when the output parameter is set to "singleDf".}

\item{output}{A character string specifying whether the output of the 
anota2seqAnalyze ("full") or the anota2seqSelSigGenes ("selected") function
should be returned. This parameter can also be set to "regModes" in which 
case the output of anota2seqRegModes is returned (i.e. identifiers which 
were given as single regulatory mode).Lastly, the parameter can be set to "singleDf"
in this case the function returns a single data frame with apvEff and apvRvmPadj values for
translated mRNA, total mRNA, translation and buffering. Additionally,there is a column "singleRegMode" 
indicating the regulatory mode the identifier belongs to and corresponds to the visualization
with the \code{\link{anota2seqPlotFC}} function.
}

\item{selContrast}{A numeric vector specifying for which contrast the output 
should be retrieved. The contrast number corresponds to the position of the
column in the automatically generated or specified contrast matrix.}

\item{getRVM}{TRUE or FALSE indicating whether the RVM output be retrieved. 
Default is TRUE. NOTE: the output of anota2seqAnalyze (accessed with output
= "full") is available both with RVM (getRVM = TRUE) and without RVM (getRVM = 
FALSE). However, when RVM was set to TRUE, respectively FALSE, in the 
anota2seqRun or anota2seqSelSigGenes functions, all subsequent filtering is 
done on the RVM, respectively no-RVM, output.}
}
\value{
Returns a data.frame with the following columns:
  
  If getRVM is FALSE: A data.frame with statistics from the applied APV for 
  that contrast. Columns are: \itemize{ \item apvSlope: the common slope used
  in APV; \item apvSlopeP: for translation if the slope is <0 or >1 a p-value
  for the slope being <0 or >1 is calculated; if the slope is >=0 & <=1 this 
  value is set to 1. For buffering if the slope is <-1 or >0 a p-value for 
  the slope being <-1 or >0 is calculated; if the slope is >=-1 & <=0 this 
  value is set to 1; \item unadjustedResidError: (the residual error before 
  calculating the effective residual error); \item apvEff: the group effect; 
  log2FC. Please note that when analyzing changes in translational efficiency 
  leading to buffering (and only for this analysis), an identifier with positive 
  apvEff will be interpreted as being buffered down and a negative apvEff 
  buffered up (see vignette for more details); \item apvMSerror: the effective 
  mean square error; \item apvF: the 
  F-value; \item residDf: the residual degrees of freedom; \item apvP: the 
  p-value; \item apvPAdj: the adjusted p-value. }
  
  if getRVM is TRUE: A data.frame with RVM statistics from the applied APV. 
  Columns are: \itemize{ \item apvSlope: the common slope used in APV; \item 
  apvSlopeP: for translation if the slope is <0 or >1 a p-value for the slope
  being <0 or >1 is calculated; if the slope is >=0 & <=1 this value is set 
  to 1. For buffering if the slope is <-1 or >0 a p-value for the slope being
  <-1 or >0 is calculated; if the slope is >=-1 & <=0 this value is set to 1;
  \item apvEff: the group effect; log2FC; Please note that when analyzing 
  changes in translational efficiency leading to buffering (and only for this 
  analysis), an identifier with positive apvEff will be interpreted as being 
  buffered down and a negative apvEff buffered up (see vignette for more 
  details) \item apvRvmMSerror: the effective 
  mean square error after RVM; \item apvRvmF: the RVM F-value; \item 
  residRvmDf: the residual degrees of freedom after RVM; \item apvRvmP: the 
  RVM p-value; \item apvRvmPAdj: the adjusted RVM p-value. }
  
  The output of anota2seqSelSigGenes contains a matrix with the same columns 
  and with a subset of rows corresponding to filtered identifiers.
  
  When anota2seqRegModes has been run on the object, an additional column 
  named singleRegMode is added indicating the allocated regulatory mode of 
  each identifier.
  
  While in the output of anota2seqSelSigGenes (accessed with output =
  "selected") a same identifier can be selected in several regulatory modes
  (e.g. both translation up and mRNA abundance up), the output of
  anota2seqRegModes (accessed with output = "regModes") shows a single
  regulatory mode allocated to each identifier according to the priority rule
  explained in the Details section.
}
\description{
The function is used to access the outputs from the anota2seqAnalyze, 
anota2seqSelSigGenes and anota2seqRegModes stored in the Anota2seqDataSet
}
\details{
This function is used to access outputs from the anota2seqRun, 
anota2seqAnalyze, anota2seqSelSigGenes and anota2seqRegModes functions 
stored within the Anota2seqDataSet. The output of the anota2seqAnalyze 
function holds analysis results on all identifiers (slope, p-value of test on 
slope value, residual error, group effect, mean square error, F-value, residual 
degrees of freedom, p-value, adjusted p-value) and is accessed with output = 
"full". The output of the anota2seqSelSigGenes function is a reduced set based 
on filtering criteria and is accessed using output = "selected". In the case of 
accessing the output of anota2seqRegModes (output = "regModes"), the output will 
further be reduced by removal of the overlap between regulatory modes so that
each gene has a unique regulatory mode. For this, we prioritize regulatory 
patterns so that translation > mRNA abundance > buffering (i.e. if an 
identifier is found as changing its translational efficiency leading to 
altered protein levels and mRNA abundance it will be removed from the mRNA 
abundance group). Lastly, to access a single data frame with 
merged apvEff and apvRvmPAdj results only from the analysis of translated mRNA, total mRNA,
translation and buffering with indicated regulatory mode for each identifier the parameter
can be set to output = "singleDf".
}
\examples{
# Initialize the Anota2seqDataSet
Anota2seqDataSet <- anota2seqDataSetFromMatrix(
    dataP = anota2seq_data_P[1:100,],
    dataT = anota2seq_data_T[1:100,],
    phenoVec = anota2seq_pheno_vec,
    dataType = "RNAseq",
    normalize = TRUE)
# Perform analysis of changes in translational efficiency leading to altered 
# protein levels
Anota2seqDataSet <- anota2seqAnalyze(Anota2seqDataSet, analysis = "translation",
                                     useProgBar = FALSE)

# Filter
Anota2seqDataSet <- anota2seqSelSigGenes(Anota2seqDataSet, selContrast = 1,
                                         maxPAdj = .2, analysis = "translation")

# Get output for analysis of changes in translational efficiency leading to
# altered protein levels
translationResults <- anota2seqGetOutput(Anota2seqDataSet,
                                  output= "full",
                                  analysis="translation",
                                  selContrast = 1,
                                  getRVM = TRUE)

# Get the selected output for analysis of changes in translational efficiency
# leading to altered protein levels
translationResultsSig <- anota2seqGetOutput(Anota2seqDataSet,
                                  output= "selected",
                                  analysis="translation",
                                  selContrast = 1,
                                  getRVM = TRUE)

}
\seealso{
\code{\link{anota2seqRun}}, 
  \code{\link{anota2seqAnalyze}}, \code{\link{anota2seqSelSigGenes}}, 
  \code{\link{anota2seqRegModes}}
}
