% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomize.R
\name{randomize_regions}
\alias{randomize_regions}
\title{Randomize Regions}
\usage{
randomize_regions(
  regions,
  allow.overlaps = TRUE,
  per.chromosome = TRUE,
  quiet = FALSE
)
}
\arguments{
\item{regions}{A \code{GRanges} object from \code{read_regions}.}

\item{allow.overlaps}{A logical stating whether random regions can overlap input regions (TRUE) or not (FALSE). Default TRUE.}

\item{per.chromosome}{A logical stating whether the random regions should remain on the same chromosome (TRUE) or not (FALSE). Default TRUE.}

\item{quiet}{Print progress messages (FALSE) or not (TRUE).}
}
\value{
A \code{GRanges} object of randomized regions based on \code{regions} from \code{read_regions()}. NOTE: Data associated with the original regions is not attached to the randomized regions.
}
\description{
\code{randomize_regions} is a wrapper function for \code{regioneR::randomizeRegions()} that simplifies the creation of randomized regions for an input set of regions read with \code{read_regions()}. It relies on the \code{seqlengths} of \code{regions} in order to build the appropriate \code{genome} object for \code{regioneR::randomizeRegions()}.
}
\details{
NOTE: The data associated with the input \code{regions} are not passed on to the random regions.
}
\examples{
   # Create random region set based on ENCODE ChIP-seq data
   file = system.file('extdata', 'Gm12878_Stat3_chr2.bed.gz', package = 'annotatr')
   r = read_regions(con = file, genome = 'hg19')

   random_r = randomize_regions(regions = r)

}
