% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_categorize.R
\name{filter_categorize}
\alias{filter_categorize}
\title{Categorize continuous variables}
\usage{
filter_categorize(
  sam_table,
  sample_condition,
  new_label,
  nbins = NULL,
  bin_breaks = c(),
  bin_labels = c()
)
}
\arguments{
\item{sam_table}{A sample x condition dataframe}

\item{sample_condition}{Continuous variable to categorize}

\item{new_label}{Column name for categorized variable}

\item{nbins}{Auto select ranges for n bins/categories}

\item{bin_breaks}{Manually select ranges for bins/categories}

\item{bin_labels}{Manually label bins/categories}
}
\value{
A list with an updated sample table and before/after plots
}
\description{
Categorize continuous variables
}
\examples{
library(SummarizedExperiment)
data_dir <- system.file("extdata/MAE.rds", package = "animalcules")
toy_data <- readRDS(data_dir)
microbe <- MultiAssayExperiment::experiments(toy_data)[[1]]
samples <- as.data.frame(colData(microbe))
result <- filter_categorize(samples,
  sample_condition = "AGE",
  new_label = "AGE_GROUP",
  bin_breaks = c(0, 55, 75, 100),
  bin_labels = c("Young", "Adult", "Elderly")
)
result$sam_table
result$plot.unbinned
result$plot.binned

}
