% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_angles.R
\name{extract_angles}
\alias{extract_angles}
\title{Calculate cosine angle between genes}
\usage{
extract_angles(x_mat, method = "cosine")
}
\arguments{
\item{x_mat}{An \code{\link[bigstatsr]{FBM}} object containing raw gene
expression data, where rows correspond to genes and columns to samples.
The data will be normalized and scaled within the function.}

\item{method}{A character string specifying the method to compute the
gene-gene relationships. Options are:
\itemize{
\item \code{"cosine"} (default): Computes the cosine angle between
genes.
\item \code{"spearman"}: Computes the Spearman rank correlation
coefficient by rank-transforming the data before computing the
correlation.
}}
}
\value{
An \code{\link[bigstatsr]{FBM}} object containing the gene-gene
correlation matrix. The matrix is square with dimensions equal to the
number of genes and contains the pairwise correlations between genes.
The diagonal elements are set to \code{NA}.
}
\description{
Constructs a matrix of gene-gene relationships based on distance
metrics.
}
\details{
The function returns the gene-gene angle matrix as an
\code{\link[bigstatsr]{FBM}} object.
}
\examples{

mat <- matrix(
 c(
     5, 3, 0, 0,
     0, 0, 0, 3,
     2, 1, 3, 4,
     0, 0, 1, 0,
     1, 2, 1, 2,
     3, 4, 3, 4
   ),
   nrow = 6, # 6 genes
   ncol = 4, # 4 cells
   byrow = TRUE
)

mat <- bigstatsr::FBM(nrow = nrow(mat), ncol = ncol(mat), init = mat)

angle_mat <- extract_angles(mat)
angle_mat[]
}
\seealso{
\code{\link[bigstatsr]{big_apply}},
\code{\link[bigstatsr]{big_cor}},
\code{\link[bigstatsr]{FBM}},
\code{\link{factorise}}
}
