% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amplicanFilter.R
\name{amplicanFilter}
\alias{amplicanFilter}
\title{Filter Events Overlapping Primers, PRIMER DIMERS and Low Alignment Score
Events.}
\usage{
amplicanFilter(aln, cfgT, PRIMER_DIMER)
}
\arguments{
\item{aln}{(data.frame) Should contain events from alignments in GRanges
style with columns eg. seqnames, width, start, end.}

\item{cfgT}{(data.frame) Needs columns Forward_Primer, ReversePrimer and
Amplicon.}

\item{PRIMER_DIMER}{(numeric) Value specifying buffer for PRIMER DIMER
detection. For a given read it will be recognized as PRIMER DIMER when
alignment will introduce gap of size bigger than: \cr
\code{length of amplicon - (lengths of PRIMERS + PRIMER_DIMER value)}}
}
\value{
(aln) Reduced by events classified as PRIMER DIMER or overlapping
primers.
}
\description{
Very often alignments return deletions that are not real deletions, but
rather artifact of incomplete reads eg.: \cr
\preformatted{
ACTGAAAAA------- <- this "deletion" should be filtered
ACTG----ACTGACTG
}
We call them Events Overlapping Primers and filter them together
with reads that are potentially PRIMER DIMERS. This filter will also remove
all events coming from reads with low alignment score - potential
Off-targets.
}
\examples{
file_path <- system.file("extdata", "results", "alignments",
                         "raw_events.csv", package = "amplican")
aln <- data.table::fread(file_path)
cfgT <- data.table::fread(
  system.file("extdata", "results", "config_summary.csv",
              package = "amplican"))
amplicanFilter(aln, cfgT, 30)

}
\seealso{
\code{\link{findPD}} and \code{\link{findEOP}}

Other analysis steps: 
\code{\link{amplicanAlign}()},
\code{\link{amplicanConsensus}()},
\code{\link{amplicanMap}()},
\code{\link{amplicanNormalize}()},
\code{\link{amplicanOverlap}()},
\code{\link{amplicanPipeline}()},
\code{\link{amplicanPipelineConservative}()},
\code{\link{amplicanReport}()},
\code{\link{amplicanSummarize}()}
}
\concept{analysis steps}
