% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveSpatialExperiment.R
\name{saveObject,SpatialExperiment-method}
\alias{saveObject,SpatialExperiment-method}
\alias{stageObject,SpatialExperiment-method}
\title{Save a spatial experiment}
\usage{
\S4method{saveObject}{SpatialExperiment}(x, path, ...)
}
\arguments{
\item{x}{A \linkS4class{SpatialExperiment} object.}

\item{path}{String containing the path to a directory in which to save \code{x}.}

\item{...}{Additional named arguments to pass to specific methods.}
}
\value{
\code{x} is saved to \code{path} and \code{NULL} is invisibly returned.
}
\description{
Save a \linkS4class{SpatialExperiment} object to its on-disk representation.
}
\details{
Currently, only PNG and TIFF image formats are supported in the \code{\link{imgData}}.
All other images will be re-saved as PNG.
}
\examples{
library(SpatialExperiment)
example(read10xVisium, echo=FALSE)

tmp <- tempfile()
saveObject(spe, tmp)
list.files(tmp, recursive=TRUE)

}
\seealso{
\code{\link{readSpatialExperiment}}, to read the SpatialExperiment back into the R session.
}
\author{
Aaron Lun
}
