% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readSFE.R
\name{readSpatialFeatureExperiment}
\alias{readSpatialFeatureExperiment}
\title{Read SFE object from alabaster on disk representation}
\usage{
readSpatialFeatureExperiment(path, metadata = NULL, ...)
}
\arguments{
\item{path}{String containing a path to a directory, itself created with a \code{\link[alabaster.base]{saveObject}} method.}

\item{metadata}{Named list containing metadata for the object - most importantly, the \code{type} field that controls dispatch to the correct loading function.
If \code{NULL}, this is automatically read by \code{\link[alabaster.base]{readObjectFile}(path)}.}

\item{...}{Further arguments to pass to individual methods.}
}
\value{
A \code{SpatialFeatureExperiment} object
}
\description{
Read SFE object from alabaster on disk representation
}
\examples{
library(SFEData)
fp <- tempfile()
fn <- file.path(fp, "vizgen")
d <- VizgenOutput(dataset = "cellpose", file_path = fn)
suppressWarnings(sfe <- readVizgen(d))
fsave <- file.path(fp, "sfe_save")
saveObject(sfe, fsave)
sfe2 <- readObject(fsave)

}
