% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GmtFileReference.R
\docType{class}
\name{GmtFileReference}
\alias{GmtFileReference}
\alias{GmtFileReference-class}
\alias{saveObject,GmtFileReference-method}
\alias{readGmtFileReference}
\alias{GmtWrapper}
\alias{GmtWrapper-class}
\alias{stageObject,GmtWrapper-method}
\alias{loadGmtWrapper}
\title{Reference to a GMT file}
\usage{
GmtFileReference(path)
}
\arguments{
\item{path}{String containing the path to a Gzip-compressed GMT file.}
}
\value{
A GmtFileReference instance that can be used in \code{\link{stageObject}}.
}
\description{
Reference to a GMT file, for saving and loading in the \pkg{alabaster} framework.
}
\examples{
# Mocking up a GMT file.
tmp <- tempfile(fileext=".gmt.gz")
write("SET1\tdescription\tgene1\tgene2\tgene3", file=gzfile(tmp))

# Creating a GmtFileReference.
wrapped <- GmtFileReference(tmp)
wrapped

# Saving to disk:
dir <- tempfile()
saveObject(wrapped, dir)

# Loading it back again:
readObject(dir)

}
\author{
Aaron Lun
}
