% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quickReadCsv.R
\name{quickReadCsv}
\alias{quickReadCsv}
\alias{.quickReadCsv}
\alias{.quickWriteCsv}
\alias{quickWriteCsv}
\title{Quickly read and write a CSV file}
\usage{
quickReadCsv(
  path,
  expected.columns,
  expected.nrows,
  compression,
  row.names,
  parallel = TRUE
)

quickWriteCsv(
  df,
  path,
  ...,
  row.names = FALSE,
  compression = "gzip",
  validate = TRUE
)
}
\arguments{
\item{path}{String containing a path to a CSV to read/write.}

\item{expected.columns}{Named character vector specifying the type of each column in the CSV (excluding the first column containing row names, if \code{row.names=TRUE}).}

\item{expected.nrows}{Integer scalar specifying the expected number of rows in the CSV.}

\item{compression}{String specifying the compression that was/will be used.
This should be either \code{"none"}, \code{"gzip"}.}

\item{row.names}{For \code{.quickReadCsv}, a logical scalar indicating whether the CSV contains row names. 

For \code{.quickWriteCsv}, a logical scalar indicating whether to save the row names of \code{df}.}

\item{parallel}{Whether reading and parsing should be performed concurrently.}

\item{df}{A \link[S4Vectors]{DFrame} or data.frame object, containing only atomic columns.}

\item{...}{Further arguments to pass to \code{\link{write.csv}}.}

\item{validate}{Whether to double-check that the generated CSV complies with the comservatory specification.}
}
\value{
For \code{.quickReadCsv}, a \link[S4Vectors]{DFrame} containing the contents of \code{path}.

For \code{.quickWriteCsv}, \code{df} is written to \code{path} and a \code{NULL} is invisibly returned.
}
\description{
Quickly read and write a CSV file, usually as a part of staging or loading a larger object.
This assumes that all files follow the \href{https://github.com/ArtifactDB/comservatory}{comservatory} specification.
}
\examples{
library(S4Vectors)
df <- DataFrame(A=1, B="Aaron")

temp <- tempfile()
.quickWriteCsv(df, path=temp, row.names=FALSE, compression="gzip")

.quickReadCsv(temp, c(A="numeric", B="character"), 1, "gzip", FALSE)

}
\author{
Aaron Lun
}
