% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glimma.R
\name{doGlimma}
\alias{doGlimma}
\title{A function to generate MA-plots from Glimma, for all contrasts.}
\usage{
doGlimma(
  tablst,
  datobj,
  dsgn,
  cont,
  grpvec,
  padj = "BH",
  sigfilt = 0.05,
  extraname = NULL,
  ID = NULL,
  sample.cols = rep("#1f77b4", ncol(datobj)),
  ...
)
}
\arguments{
\item{tablst}{An MArrayLM object or list of DGEExact or DGELRT objects}

\item{datobj}{A DGEList, ExpressionSet, EList or matrix}

\item{dsgn}{A design matrix}

\item{cont}{A contrast matrix}

\item{grpvec}{A vector of groups, usually what was used to make the design matrix}

\item{padj}{Method for multiplicity adjustment. BH by default}

\item{sigfilt}{Significance cutoff for selecting genes}

\item{extraname}{Used to add a sub-directory to the glimma-plots directory, mainly used to
disambiguate contrasts with the same name (see below).}

\item{ID}{Character, default is NULL. The column name of the genes list item (from the MArrayLM,
DGEExact or DGELRT objects) that will be used for labeling the individual gene expression plot
at the top right of the resulting plot. The default of NULL will search for a column labeled
SYMBOL to use. If the ID value doesn't match any column, and there is no SYMBOL column, then
the default for glMDPlot will be used.}

\item{sample.cols}{A vector of numbers or hex strings, the same length as the grpvec. This
will cause the samples in the upper right plot to have different colors. Useful primarily to
check for batch differences. The default is the default from glMDPlot.}

\item{...}{Allows end users to pass other arguments to the Glimma glMDPlot function}
}
\value{
A character vector of the files generated, useful for using as links to the output.
}
\description{
This function is designed to parse a design and contrasts matrix in order to
generate Glimma's interactive MA-plots for all contrasts. The heading for the
resulting plot is based on the colnames of the contrasts matrix, so it is important
to include the colnames and make them explanatory.
}
\details{
In addition, if there are multiple contrasts with the same name, say if the same
comparisons are being made for different tissue types, the extraname argument will cause
the output to be placed in glimma-plots/<extraname>, to eliminate over-writing of existing
files.
}
\examples{
  \dontrun{
    mat <- matrix(rnorm(1e6), ncol = 20)
    grps <- factor(1:4, each=5)
    design <- model.matrix(~0 + grps)
    colnames(design) <- LETTERS[1:4]
    contrast <- matrix(c(1,-1,0,0,1,0,-1,0,1,0,0,-1,0,1,-1,0,0,1,0,-1),
    ncol = 5)
    colnames(contrast) <- paste(LETTERS[c(1,1,1,2,2)],
    LETTERS[c(2,3,4,3,4)], sep = " vs ")
    fit <- lmFit(mat, design)
    fit2 <- contrasts.fit(fit, contrast)
    fit2 <- eBayes(fit2)
    htmllinks <- doGlimma(fit2, mat, design, contrast, grps)
   }
}
\author{
James W. MacDonald \email{jmacdon@u.washington.edu}
}
\keyword{manip}
