% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00AdductSpec-class.R
\docType{class}
\name{AdductSpec-class}
\alias{AdductSpec-class}
\alias{show,c,Specfile.paths,adductMS2spec,metaData,AdductSpec-class}
\alias{groupMS2spec,rtDevModels,sumAdductType,Parameters,AdductSpec-class}
\alias{Peptides,specPepMatches,AdductSpec-class}
\alias{x}
\alias{c,Specfile.paths,adductMS2spec,metaData,Parameters,AdductSpec-method}
\alias{groupMS2spec,rtDevModels,sumAdductType,Peptides,AdductSpec-method} 
\alias{specPepMatches,AdductSpec-method}
\alias{c,AdductSpec-method}
\title{AdductSpec class}
\format{An object of class \code{NULL} of length 0.}
\usage{
x
}
\value{
dynamic noise filtered composite MS/MS spectra
and their corresponding MS1 scan isotopic patterns
}
\description{
The AdductSpec class contains dynamic noise filtered composite MS/MS spectra
and their corresponding MS1 scan isotopic patterns. Produced by
adductSpecGen() from mzXML files.
}
\section{Slots}{

\describe{
\item{\code{adductMS2spec}}{list of adduct MS2 spectras}

\item{\code{groupMS2spec}}{list of group MS2 spectras}

\item{\code{metaData}}{dataframe of metadata from mzXML}

\item{\code{aaResSeqs}}{matrix of amino acid sequences}

\item{\code{specPepMatches}}{list of spectra peptide matches}

\item{\code{specPepCompSpec}}{list of comp spectra peptide matches}

\item{\code{sumAdductType}}{dataframe of adduct types}

\item{\code{Peptides}}{dataframe of peptides under study}

\item{\code{rtDevModels}}{list of rtDevModels}

\item{\code{targetTable}}{dataframe target table}

\item{\code{file.paths}}{character of file path}

\item{\code{Parameters}}{dataframe of parameters}
}}

\section{Methods}{

\describe{
\item{c}{\code{signature(object = "AdductSpec")}: Concatenates the 
spectra information.}
\item{Specfile.paths}{\code{signature(object = "AdductSpec")}: Accesses the 
file paths.}
\item{adductMS2spec}{\code{signature(object = "AdductSpec")}: Accesses the 
adduct MS2 spectral information.}
\item{metaData}{\code{signature(object = "AdductSpec")}: Accesses the 
scan metadata.}
\item{Parameters}{\code{signature(object = "AdductSpec")}: Accesses the 
user parameters.}
\item{groupMS2spec}{\code{signature(object = "AdductSpec")}: Accesses the 
spectral information for the grouped MS2 spectra.}
\item{rtDevModels}{\code{signature(object = "AdductSpec")}: Accesses the 
retention time deviation models.}
\item{sumAdductType}{\code{signature(object = "AdductSpec")}: Accesses the 
total adduct types.}
\item{Peptides}{\code{signature(object = "AdductSpec")}: Accesses the 
peptide information.}
\item{specPepMatches}{\code{signature(object = "AdductSpec")}: Accesses the 
peptide matches in the spectra.}
}
}

\author{
JL Hayes \email{jlhayes1982@gmail.com}
}
\keyword{datasets}
