% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{.plotDist}
\alias{.plotDist}
\title{Bar plotter}
\usage{
.plotDist(dataframes, sampleNames, plotTitle, vert = TRUE, xlabel = "",
  ylabel = "", perc = TRUE, subs = "", sorted = TRUE,
  cutoff = 15, legendPos = "right")
}
\arguments{
\item{dataframes}{list type. List of dataframes}

\item{sampleNames}{vector type. 1-1 correspondence to dataframes.}

\item{plotTitle}{string type.}

\item{vert}{boolean type. True if the plot should be vertical}

\item{xlabel}{string type}

\item{ylabel}{string type}

\item{perc}{boolean type. True if data's axis is a percentage
proportion (instead of 0-1) only used if length(sampleNames) == 1}

\item{subs}{string type}

\item{sorted}{boolean type. True if bar plot should be sorted in descending
order}

\item{cutoff}{int type. Number of maximum ticks to show (x on vert plots,
y on hori plots).}

\item{legendPos}{string type. Where to position legend (see ggplot's theme())}
}
\value{
ggplot2 object
}
\description{
Plots barplot for all sample in dataframes.
If length(sampleNames) == 1, then the bars will also have
y-values (or x if horizontal plot) labels on them.
Use 'perc' to control if the values are percentages.
}
