% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interact_foreign.R
\name{run_annotate_vcf_pl}
\alias{run_annotate_vcf_pl}
\title{Wrapper function to annotate addition information}
\usage{
run_annotate_vcf_pl(
  in_data_file,
  in_anno_track_file,
  in_new_column_name,
  out_file,
  in_data_file_type = "custom",
  in_anno_track_file_type = "bed",
  in_data_CHROM.field = "CHROM",
  in_data_POS.field = "POS",
  in_data_END.field = "POS"
)
}
\arguments{
\item{in_data_file}{Path to the input vcf-like file to be annotated}

\item{in_anno_track_file}{Path to the input file containing the annotation
track}

\item{in_new_column_name}{String indicating the name of the column to be
created for annotation.}

\item{out_file}{Path where the created files can be stored.}

\item{in_data_file_type}{\code{custom} for vcf-like}

\item{in_anno_track_file_type}{Type of the file \code{in_anno_track_file}
containing the annotation track.}

\item{in_data_CHROM.field}{String indicating which column of
\code{in_data_file} contains the chromosome information.}

\item{in_data_POS.field}{String indicating which column of
\code{in_data_file} contains the position information.}

\item{in_data_END.field}{String indicating which column of
\code{in_data_file} contains the end information if regions are considered.}
}
\value{
Return zero if no problems occur.
}
\description{
Wrapper function to the perl script annotate_vcf.pl which annotates data of a
track stored in file_B (may be different formats) to called variants stored
in a vcf-like file_A.
}
\examples{
 NULL

}
