% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{hclust_exposures}
\alias{hclust_exposures}
\title{Cluster the PIDs according to their signature exposures}
\usage{
hclust_exposures(
  in_exposures_df,
  in_subgroups_df,
  in_method = "manhattan",
  in_subgroup_column = "subgroup",
  in_palette = NULL,
  in_cutoff = 0,
  in_filename = NULL,
  in_shift_factor = 0.3,
  in_cex = 0.2,
  in_title = "",
  in_plot_flag = FALSE
)
}
\arguments{
\item{in_exposures_df}{Numerical data frame encoding the exposures \code{H},
i.e. which signature contributes how much to which PID (patient identifier
or sample).}

\item{in_subgroups_df}{A data frame indicating which PID (patient or sample
identifyier) belongs to which subgroup}

\item{in_method}{Method of the clustering to be supplied to
\code{\link{dist}}. Can be either of: \code{euclidean}, \code{maximum},
\code{manhattan}, \code{canberra}, \code{binary} or \code{minkowski}}

\item{in_subgroup_column}{Indicates the name of the column in which the
subgroup information is encoded in \code{in_subgroups_df}}

\item{in_palette}{Palette with colours or colour codes for the labels (the
text) of the leaves in the dendrogram. Typically one colour per subgroup.
If none is specified, a rainbow palette of the length of the number of
subgroups will be used as default.}

\item{in_cutoff}{A numeric value less than 1. Signatures from within \code{W}
with an overall exposure less than \code{in_cutoff} will be discarded for
the clustering.}

\item{in_filename}{A path to save the dendrogram. If none is specified, the
figure will be plotted to the running environment.}

\item{in_shift_factor}{Graphical parameter to adjust figure to be created}

\item{in_cex}{Graphical parameter to adjust figure to be created}

\item{in_title}{Title in the figure to be created under \code{in_filename}}

\item{in_plot_flag}{Whether or not to display the dendrogram}
}
\value{
A list with entries \code{hclust} and \code{dendrogram}. \itemize{
  \item \code{hclust}: The object created by \code{\link{hclust}} \item
  \code{dendrogram}: The above object wrapped in \code{\link{as.dendrogram}}
  }
}
\description{
The PIDs are clustered according to their signature exposures by calling
first creating a distance matrix: \itemize{ \item \code{\link{dist}}, then
\item \code{\link{hclust}} and then \item
\code{\link[dendextend]{labels_colors}} to colour the labels (the text) of
the leaves in the dendrogram. } Typically one colour per subgroup.
}
\examples{
 data(lymphoma_cohort_LCD_results)
 hclust_exposures(rel_lymphoma_Nature2013_COSMIC_cutoff_exposures_df,
                  COSMIC_subgroups_df,
                  in_method="manhattan",
                  in_subgroup_column="subgroup")

}
\seealso{
\code{\link{hclust}}

\code{\link{dist}}

\code{\link[dendextend]{labels_colors}}
}
