% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_functions.R
\name{attribute_nucleotide_exchanges}
\alias{attribute_nucleotide_exchanges}
\title{Attribute the nucleotide exchange for an SNV}
\usage{
attribute_nucleotide_exchanges(
  in_dat,
  in_REF.field = "REF",
  in_ALT.field = "ALT",
  in_verbose = FALSE
)
}
\arguments{
\item{in_dat}{VRanges object or data frame which carries one column for the
reference base and one column for the variant base}

\item{in_REF.field}{String indicating which column of \code{in_dat} carries
the reference base if dealing with data frames}

\item{in_ALT.field}{String indicating which column of \code{in_dat} carries
the variant base if dealing with data frames}

\item{in_verbose}{Whether verbose or not.}
}
\value{
A character vector with as many rows as there are in \code{in_dat}
  which can be annotated (i.e. appended) to the input data frame.
}
\description{
SNVs are grouped into 6 different categories (12/2 as reverse complements are
summed over). This function defines the attribution.
}
\examples{
test_df <- data.frame(
 CHROM=c(1,1,1,2,2,2,3,3,3,4,4,4,5,5),
 POS=c(1,2,3,4,5,6,1,2,3,4,5,6,7,8),
 REF=c("C","C","C","T","T","T","A","A","A","G","G","G","N","A"),
 ALT=c("A","G","T","A","C","G","C","G","T","A","C","T","A","N"))
test_df$change <- attribute_nucleotide_exchanges(
 test_df,in_REF.field = "REF",in_ALT.field = "ALT")
test_df

}
