% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drug_Sensitivity_Signature.R
\name{drugSensitivitySig}
\alias{drugSensitivitySig}
\title{get drug sensitivity values}
\usage{
drugSensitivitySig(
  object,
  drug,
  mDataType = NULL,
  molData = NULL,
  features = NULL,
  model.ids = NULL,
  model2bidMap = NULL,
  sensitivity.measure = "slope",
  fit = c("lm", "CI", "pearson", "spearman", NA),
  standardize = c("SD", "rescale", "none"),
  nthread = 1,
  tissue = NULL,
  verbose = TRUE
)
}
\arguments{
\item{object}{The \code{Xeva} dataset.}

\item{drug}{Name of the drug.}

\item{mDataType}{Molecular data type.}

\item{molData}{External data matrix. Rows as features and columns as samples.}

\item{features}{Set which molecular data features to use. Default \code{NULL} will use all features.}

\item{model.ids}{Set which \code{model.id} to use from the dataset. Default \code{NULL} will use all \code{model.id}s.}

\item{model2bidMap}{A \code{data.frame} with \code{model.id} and \code{biobase.id}. Default \code{NULL} will use internal mapping.}

\item{sensitivity.measure}{Name of the sensitivity measure.}

\item{fit}{Association method to use, can be 'lm', 'CI', 'pearson' or 'spearman'. If 'NA' only the data will be return. Default \code{lm}.}

\item{standardize}{Default \code{SD}. Name of the method to use for data standardization before fitting.}

\item{nthread}{number of threads}

\item{tissue}{tissue type. Default \code{NULL} uses \code{'tissue'} from \code{object}.}

\item{verbose}{Default \code{TRUE} will show information}
}
\value{
A \code{data.frame} with features and values.
}
\description{
Given a Xeva object and drug name, this function will return sensitivity values for all the genes/features.
}
\details{
Method to compute association can be specified by \code{fit}. It can be one of the:
\itemize{
\item{"lm" for linear models}
\item{"CI" for concordance index}
\item{"pearson" for Pearson correlation}
\item{"spearman" for Spearman correlation}
}

If fit is set to NA, processed data (an ExpressionSet) will be returned.

A matrix of values can be directly passed to molData.
In case where a \code{model.id} maps to multiple \code{biobase.id}s, the first \code{biobase.id} in the \code{data.frame} will be used.
}
\examples{
data(brca)
senSig <- drugSensitivitySig(object=brca, drug="tamoxifen",
                             mDataType="RNASeq", features=c(1,2,3,4,5),
                             sensitivity.measure="slope", fit = "lm")

## example to compute the Pearson correlation between gene expression and PDX response
senSig <- drugSensitivitySig(object=brca, drug="tamoxifen",
                             mDataType="RNASeq", features=c(1,2,3,4,5),
                             sensitivity.measure="slope", fit = "pearson")

}
